local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")
local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local goodToGo = false
local waitingCoroutine
local coroutineEntity = monocle.Entity()

local function waitTilCameraMoved()
	wait(18)
	goodToGo = true
end

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

function onBegin()
	if not getFlag("morningWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()
		
		walkTo(636, false, 0.5)
		wait(1.0)
		say("SSC2024_fonda_morning01")
		wait(1.0)
		say("SSC2024_fonda_morning02")
		setFlag("rocket-end", true)
		wait(2.0)
		playSound("event:/game/00_prologue/intro_vignette", player.Position)
		waitingCoroutine = makeCoroutine(waitTilCameraMoved)
		cutsceneEntity:Add(waitingCoroutine)
		wait(3.5)
		say("SSC2024_fonda_morning03")
		wait(0.5)
		wait(4.0)
		while not goodToGo do
			wait()
		end
		goodToGo = false
		setFlag("teleporting", true)
		setFlag("morningWatched", true)
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("teleportingskip", true)
		setFlag("morningWatched", true)
		enableMovement()
    end
end