local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

function onBegin()
	if not getFlag("laserWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()

		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(160, 100), 3.0, 3.0)))
		walkTo(39656, false, 0.7)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(2.0)
		say("SSC2024_fonda_laser01")
		wait(0.3)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(0.3)
		say("SSC2024_fonda_laser02")
		playSound("event:/ui/main/whoosh_large_out", player.Position)
		coroutine.yield(level:ZoomBack(0.4))
		wait(0.5)
		say("SSC2024_fonda_laser03")
		player.Facing = getEnum("Celeste.Facings", "Right")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(160, 100), 2.0, 2.0)))
		wait(1.0)
		say("SSC2024_fonda_laser04")
		playSound("event:/char/badeline/boss_laser_fire", player.Position)
		playSound("event:/game/03_resort/clutterswitch_finish", player.Position)
		playSound("event:/char/oshiro/boss_transform_burst", player.Position)
		setFlag("lasercrumble", true)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 100), 3.0, 0.3)))
		setFlag("red", true)
		wait(0.1)
		setFlag("red", false)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(0.3)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(0.3)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(0.3)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(0.5)
		say("SSC2024_fonda_laser05")
		player.DummyAutoAnimate = false
		player.Sprite:Play("tired", true)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 100), 2.0, 2.0)))
		wait(1.0)
		say("SSC2024_fonda_laser06")
		wait(1.0)
		player.DummyAutoAnimate = true
		player.Sprite:Play("idle", true)
		say("SSC2024_fonda_laser07")
		coroutine.yield(level:ZoomBack(2.0))
		setFlag("laserWatched", true)
		player.ForceCameraUpdate = true
		enableMovement()
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		player.Facing = getEnum("Celeste.Facings", "Right")
		setFlag("lasercrumble", true)
		setFlag("laserWatched", true)
		setFlag("red", false)
		enableMovement()
    end
end