local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

function onBegin()
	if getFlag("keyCutscene") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()
		
		theo = celeste.NPC(player.Position - vector2(200, 0))
		level:Add(theo)
        local sprite = celeste.GFX.SpriteBank:Create("theo")
        theo:Add(sprite)
        theo.Sprite = sprite
		theo.Maxspeed = 20

		local salem = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("salem")
		salem.Maxspeed = 40
		local victor = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("victor")
		victor.Maxspeed = 40

		setFlag("rocket-end", true)
		walkTo(32440, false, 0.7)
		setFlag("death", false)
		victor.Position = vector2(32464,-3960)
		victor:SetHorizontalScale(-1)
		salem.Position = vector2(32480,-3960)
		salem:SetHorizontalScale(-1)
		theo.Position = vector2(32416,-3944)
		player.ForceCameraUpdate = false
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(32344, -4080), 0.1)))
		wait(0.5)
		level:ZoomSnap(vector2(120, 110), 2.0)
		setFlag("rocket-end", false)
		wait(2.0)

		say("SSC2024_fonda_key01")
		salem:SetHorizontalScale(1)
		victor:SetHorizontalScale(1)
		walkTo(32500, false, 0.5)
		wait(1.0)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(0.5)
		say("SSC2024_fonda_key02")
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X + 120, salem.Y)))
		salem:PlayAnimation("salemidle")
		salem.Position = vector2(0,0)
		victor:SetHorizontalScale(-1)
		wait(0.7)
		victor:SetHorizontalScale(1)
		wait(0.7)
		victor:PlayAnimation("victorwalk")
		coroutine.yield(victor:MoveTo(vector2(victor.X + 120, victor.Y)))
		victor:PlayAnimation("victoridle")
		victor.Position = vector2(0,0)

		sprite:Play("walk", false, false)
		coroutine.yield(theo:MoveTo(vector2(player.Position.X - 40, theo.Y)))
		sprite:Play("idle", false, false)
		wait(1.0)
		say("SSC2024_fonda_key04")
		wait(1.5)
		say("SSC2024_fonda_key05")
		wait(1.5)
		say("SSC2024_fonda_key06")
		wait(2.5)
		say("SSC2024_fonda_key07")
		wait(0.3)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(0.3)
		say("SSC2024_fonda_key08")
		setFlag("rocket-end", true)
		wait(1.5)
		coroutine.yield(level:ZoomBack(0.1))
		player.ForceCameraUpdate = true
		wait(0.4)
		setFlag("rocket-end", false)
		setFlag("keyCutscene", false)
		setFlag("keyWatched", true)
		setFlag("death", false)
		enableMovement()
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		local victor = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("victor")
		victor.Position = vector2(0,0)
		local salem = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("salem")
		salem.Position = vector2(0,0)
		theo.Position = vector2(32452,-3944)
		player.Position = vector2(32492,-3944)
		player.Facing = getEnum("Celeste.Facings", "Right")
		setFlag("death", false)
		setFlag("rocket-end", false)
		setFlag("keyCutscene", false)
		setFlag("keyWatched", true)
		setFlag("death", false)
		enableMovement()
    end
end