local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

local spotlight = require("#Celeste.SpotlightWipe")
local screenwipe = require("#Celeste.ScreenWipe")

function onBegin()
	if not getFlag("introWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		setFlag("bird", false)
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = false
		disableMovement()
	
		player.DummyAutoAnimate = false
		player.Sprite:Play("downed", true)

        theo = celeste.NPC(player.Position + vector2(60, 0))
        level:Add(theo)
        local sprite = celeste.GFX.SpriteBank:Create("theo")
        theo:Add(sprite)
        theo.Sprite = sprite
        sprite.Scale = vector2(-1,1)
        sprite:Play("sitDown", false, false)
		
		level:ZoomSnap(vector2(160, 120), 2)
		spotlight.FocusPoint = player.Position - getRoom().Camera.Position + vector2(30, 0)
		local wipe = spotlight(getRoom(), true)
		wipe.Duration = 2
		wait(wipe.Duration)
		wait(1.0)
		coroutine.yield(level:ZoomBack(4.0))
		wait(2.5)
		say("SSC2024_fonda_intro01")
		wait(1.5)
		say("SSC2024_fonda_intro02")
		wait(1.5)
		say("SSC2024_fonda_intro03")
		wait(1.0)
		say("SSC2024_fonda_intro04")
		wait(2.0)
		say("SSC2024_fonda_intro05")
		wait(1.5)
		say("SSC2024_fonda_intro06")
		wait(1.5)
		say("SSC2024_fonda_intro07")

		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(0, -850), 3)))
		player.ForceCameraUpdate = false
		wait(3.0)
		setFlag("logo", true)
		wait(3.5)
		setFlag("bird", true)
		wait(4.0)
		setFlag("logo", false)
		wait(2.5)
		setFlag("night", true)
		setFlag("ambience", true)
		player.Sprite:Play("asleep", true)
		theo:RemoveSelf()
		wait(3.0)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(return_pos, 3)))
		wait(4.5)

		player.Sprite:Play("wakeUp", true)
		player.ForceCameraUpdate = true
		wait(2.5)
		player.DummyAutoAnimate = true
		setFlag("introWatched", true)
		enableMovement()
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		theo:RemoveSelf()
		setFlag("target", true)
		setFlag("skip", true)
		setFlag("ambience", true)
		setFlag("night", true)
		setFlag("logo", false)
		setFlag("bird", false)
		setFlag("introWatched", true)
		enableMovement()
    end
end