local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

function onBegin()
	if not getFlag("highwayWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()
		
		local salem = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("salem")
		salem.Maxspeed = 55
		salem:SetHorizontalScale(-1)
		local victor = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("victor")
		victor.Maxspeed = 55
		victor:SetHorizontalScale(-1)

		setFlag("spaceship", false)
		setFlag("highway", false)
		player.DummyAutoAnimate = false
		player.Sprite:Play("walk")
		coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(17408, false, 0.5)))
		player.ForceCameraUpdate = false
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(18528, -3216), 8.0)))
		wait(2.0)
		setFlag("highway", true)
		wait(6.2)
		salem:SetHorizontalScale(1)
		salem:PlayAnimation("salemwalk")
		coroutineEntity:add(monocle.Coroutine(salem:MoveTo(vector2(salem.X + 80, salem.Y))))
		victor:SetHorizontalScale(1)
		victor:PlayAnimation("victorwalk")
		coroutine.yield(victor:MoveTo(vector2(victor.X + 80, victor.Y)))
		victor:PlayAnimation("victoridle")
		salem:PlayAnimation("salemidle")
		setFlag("highway", false)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(17288, -2753), 5.0)))
		wait(5.0)
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("highwayWatched", true)
		enableMovement()
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		setFlag("highway", false)
		player.Position = vector2(17408,-2648)
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("highwayWatched", true)
		enableMovement()
    end
end