local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

local sfxSoundSource = celeste.SoundSource()

function onBegin()
	if not getFlag("endingWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()

		walkTo(54888, false, 0.5)
		wait(1.5)
		say("SSC2024_fonda_ending34")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(130, 115), 1.7, 2.0)))
		wait(0.5)
		setFlag("HelloTheo", false)

		theo = celeste.NPC(player.Position + vector2(28, 0))
        level:Add(theo)
        local sprite = celeste.GFX.SpriteBank:Create("theo")
        theo:Add(sprite)
        theo.Sprite = sprite
		theo.Maxspeed = 80

		sprite.Scale = vector2(-1,1)
		wait(0.3)
		say("SSC2024_fonda_ending35")
		wait(1.0)
		say("SSC2024_fonda_ending36")
		sprite.Scale = vector2(1,1)
		setFlag("rocket-end", true)
		wait(3.2)
		theo.Position = vector2(0,0)
		player.Position = vector2(54984, -10960)
		coroutine.yield(level:ZoomBack(0.1))
		wait(0.3)
		setFlag("rocket-end", false)
		wait(3.0)
		say("SSC2024_fonda_ending37")
		playSound("event:/game/05_mirror_temple/button_activate", player.Position)
		playSound("event:/game/03_resort/clutterswitch_finish", player.Position)
		playSound("event:/game/01_forsaken_city/console_red", player.Position)
		sfxSoundSource:Play("event:/moladan/rocketstartfade")
		setFlag("smoke", true)
		setFlag("red", true)
		wait(0.1)
		setFlag("red", false)
		wait(3.0)
		setFlag("countdown", true)
		wait(10.5)
		playSound("event:/moladan/rocketliftoff", player.Position)
		wait(0.2)
		setFlag("rocket", true)
		wait(4.0)
		setFlag("logo", true)
		wait(5.0)
		setFlag("logo", false)
		wait(8.0)
		setFlag("rocket-end", true)
		wait(3.5)
		setFlag("teleporting", true)
		wait(30.0)
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		sfxSoundSource:Stop()
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("red", false)
		setFlag("logo", false)
		setFlag("teleportingskip", true)
		enableMovement()
    end
end