local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")
local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local goodToGo = false
local waitingCoroutine
local coroutineEntity = monocle.Entity()

local function waitTilCameraMoved()
	wait(40)
	goodToGo = true
end

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

function onBegin()
	if not getFlag("endingWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()

		local salem = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("salem")
		salem.Maxspeed = 25
		local victor = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("victor")
		victor.Maxspeed = 150
		victor:SetHorizontalScale(-1)

		theo = celeste.NPC(player.Position + vector2(40, 0))
        level:Add(theo)
        local sprite = celeste.GFX.SpriteBank:Create("theo")
        theo:Add(sprite)
        theo.Sprite = sprite
		theo.Maxspeed = 80

		player.Facing = getEnum("Celeste.Facings", "Right")
		level:ZoomSnap(vector2(160, 125), 3.5)
		player.DummyAutoAnimate = false
		player.Sprite:Play("asleep", true)
		sprite:Play("idleGround", false, false)
		wait(2.0)
		setFlag("rocket-end", false)
		wait(1.0)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 115), 2.0, 5.0)))
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X + 100, salem.Y)))
		salem:PlayAnimation("salemidle")
		wait(1.5)
		say("SSC2024_fonda_ending01")
		player.Sprite:Play("wakeUp", true)
		wait(3.0)
		player.ForceCameraUpdate = false
		player.DummyAutoAnimate = true
		walk(-16, false, 0.5)
		wait(0.7)
		walk(16, false, 0.5)
		wait(0.8)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 100), 1.3, 0.3)))
		playSound("event:/ui/main/whoosh_large_out", player.Position)
		say("SSC2024_fonda_ending02")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 115), 1.7, 2.0)))
		player.DummyAutoAnimate = false
		player.Sprite:Play("tired", true)
		wait(0.2)
		playSound("event:/game/04_cliffside/gondola_theo_recover", player.Position)
		sprite:Play("recoverGround", false, false)
		wait(2.0)
		say("SSC2024_fonda_ending03")
		wait(0.4)
		sprite.Scale = vector2(-1,1)
		wait(0.3)
		sprite:Play("run", false, false)
		coroutine.yield(theo:MoveTo(vector2(player.Position.X + 11, theo.Y)))
		sprite:Play("comfortStart", false, false)
		say("SSC2024_fonda_ending04")
		sprite:Play("comfortRecover", false, false)
		wait(1.0)
		theo.Maxspeed = 30
		sprite:Play("walk", false, false)
		coroutine.yield(theo:MoveTo(vector2(player.Position.X - 24, theo.Y)))
		sprite:Play("idle", false, false)
		wait(0.3)
		say("SSC2024_fonda_ending05")
		player.Facing = getEnum("Celeste.Facings", "Left")

		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(53536, -11569), 4.0)))
		wait(5.0)
		salem:PlayAnimation("salempull")
		wait(1.2)
		playSound("event:/ui/main/whoosh_large_out", player.Position)
		playSound("event:/char/badeline/temple_move_first", player.Position)
		wait(1.5)
		say("SSC2024_fonda_ending06")
		wait(1.0)
		say("SSC2024_fonda_ending07")
		setFlag("musicFade", true)
		setFlag("rocket-end2", true)
		wait(6.0)
		playSound("event:/char/badeline/temple_move_chats", player.Position)
		say("SSC2024_fonda_ending08")
		wait(1.0)
		victor.Position = vector2(salem.X + 24, victor.Y)
		setFlag("rocket-end2", false)
		playMusic("event:/moladan/TUNIC (Original Soundtrack) - 27 The Librarian Lifeformed Janice Kwan")
		wait(3.0)
		say("SSC2024_fonda_ending09")

		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(110, 125), 2.2, 4.0)))
		wait(3.0)
		say("SSC2024_fonda_ending10")
		victor:PlayAnimation("victorwalk")
		coroutine.yield(victor:MoveTo(vector2(victor.X + 8, victor.Y)))
		victor:PlayAnimation("victoridle")
		say("SSC2024_fonda_ending11")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(110, 125), 3.5, 40.0)))
		waitingCoroutine = makeCoroutine(waitTilCameraMoved)
		cutsceneEntity:Add(waitingCoroutine)
		say("SSC2024_fonda_ending12")
		setFlag("rocket-end", true)
		setFlag("musicFade2", true)
		wait(6.0)
		say("SSC2024_fonda_ending13")
		playSound("event:/char/badeline/boss_laser_charge", player.Position)
		wait(1.7)
		say("SSC2024_fonda_ending14")
		wait(1.0)
		playSound("event:/char/badeline/boss_laser_fire", player.Position)
		setFlag("white", true)
		wait(6.0)
		victor.Position = vector2(0, 0)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(53536, -11569), 0.1)))
		setFlag("white", false)
		wait(4.0)
		while not goodToGo do
			wait()
		end
		goodToGo = false
		level:ZoomSnap(vector2(160, 115), 1.7)
		setFlag("rocket-end", false)
		playMusic("event:/moladan/Re Desire for Execution")
		celeste.Audio.SetMusicParam("fade", 1.0)
		wait(4.5)
		say("SSC2024_fonda_ending15")
		player.DummyAutoAnimate = true
		walk(-64, false, 1.5)
		say("SSC2024_fonda_ending16")
		celeste.Audio.SetMusicParam("fade", 0.0)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(110, 125), 2.5, 0.5)))
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(53530, -11569), 0.5)))
		playSound("event:/ui/main/whoosh_large_out", player.Position)
		wait(0.5)
		say("SSC2024_fonda_ending17")
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(53580, -11569), 0.5)))
		playSound("event:/ui/main/whoosh_large_out", player.Position)
		wait(0.5)
		say("SSC2024_fonda_ending18")
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(53530, -11569), 0.5)))
		playSound("event:/ui/main/whoosh_large_out", player.Position)
		wait(0.5)
		say("SSC2024_fonda_ending19")
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(53560, -11569), 1.0)))
		wait(1.0)
		say("SSC2024_fonda_ending20")
		walk(-48, false, 0.5)
		wait(1.0)
		setFlag("note", true)
		playSound("event:/game/03_resort/memo_in", player.Position)
		wait(1.0)

		local Talked = false
		while not Talked do
			if celeste.Input.MenuConfirm.Check then
				Talked = true
			else
				wait()
			end
		end

		setFlag("noteMove", true)
		playSound("event:/game/03_resort/memo_out", player.Position)
		wait(2.0)
		walk(48, false, 0.5)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(0.5)
		say("SSC2024_fonda_ending21")
		wait(1.5)
		salem:PlayAnimation("salemnogun")
		playSound("event:/char/madeline/summit_sit", player.Position)
		playMusic("event:/moladan/OMORI OST - 088 Lost Library")
		wait(2.0)
		say("SSC2024_fonda_ending22")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(110, 115), 1.7, 2.5)))
		wait(1.5)
		say("SSC2024_fonda_ending23")
		wait(0.2)
		salem:SetHorizontalScale(-1)
		wait(0.2)
		say("SSC2024_fonda_ending24")
		wait(1.0)
		say("SSC2024_fonda_ending25")
		wait(0.2)
		salem:SetHorizontalScale(1)
		wait(0.2)
		say("SSC2024_fonda_ending26")
		setFlag("musicFade3", true)
		wait(1.0)
		say("SSC2024_fonda_ending27")
		wait(3.0)
		playMusic("event:/moladan/Interstellaria OST - Somnolence")
		celeste.Audio.SetMusicParam("fade", 1.0)
		say("SSC2024_fonda_ending28")
		wait(1.0)
		salem:SetHorizontalScale(-1)
		say("SSC2024_fonda_ending29")
		wait(0.5)
		salem:SetHorizontalScale(1)
		wait(0.5)
		say("SSC2024_fonda_ending30")
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(53590, -11569), 2.5)))
		wait(1.0)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(1.8)
		say("SSC2024_fonda_ending31")
		wait(0.4)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(1.0)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(1.0)
		say("SSC2024_fonda_ending32")
		theo.Maxspeed = 50
		sprite:Play("walk", false, false)
		coroutine.yield(theo:MoveTo(vector2(theo.X + 100, theo.Y)))
		sprite:Play("idle", false, false)
		walk(60, false, 0.5)
		wait(0.3)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(1.5)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(0.4)
		walk(80)
		say("SSC2024_fonda_ending33")
		setFlag("note", false)
		setFlag("rocket-end", true)
		wait(5.0)
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		enableMovement()
		setFlag("teleporting", true)
		wait(30.0)
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("rocket-end", false)
		setFlag("red", false)
		setFlag("white", false)
		setFlag("note", false)
		setFlag("teleportingskip", true)
		enableMovement()
    end
end