local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()
local sfxSoundSource1 = celeste.SoundSource()
local sfxSoundSource2 = celeste.SoundSource()

local function alarm(time)
	playSound("event:/classic/sfx23", player.Position)
	playSound("event:/game/01_forsaken_city/console_red", player.Position)
	wait(time)
	playSound("event:/classic/sfx23", player.Position)
	wait(time)
	playSound("event:/classic/sfx23", player.Position)
	wait(time)
	playSound("event:/classic/sfx23", player.Position)
	wait(time)
end

function onBegin()
	if not getFlag("endingWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()

		local salem = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("salem")
		salem.Maxspeed = 80

		level:ZoomSnap(vector2(160, 100), 1.5)
		wait(1.5)
		setFlag("rocket-end", false)
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X + 200, salem.Y)))
		salem:PlayAnimation("salemidle")
		wait(0.3)
		say("SSC2024_fonda_attack01")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 100), 2.5, 0.3)))
		playSound("event:/char/badeline/appear", player.Position)
		wait(0.3)
		say("SSC2024_fonda_attack02")
		playSound("event:/game/03_resort/suite_bad_movestageleft", player.Position)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 100), 1.5, 2.0)))
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(53696, -14624), 15.0)))
		wait(3.5)
		playSound("event:/char/badeline/boss_laser_charge", player.Position)
		playSound("event:/char/oshiro/boss_precharge", player.Position)
		wait(1.5)
		playSound("event:/new_content/game/10_farewell/lightning_strike", player.Position)
		playSound("event:/char/badeline/boss_laser_fire", player.Position)
		playSound("event:/char/oshiro/boss_transform_burst", player.Position)
		playSound("event:/game/03_resort/clutterswitch_finish", player.Position)
		setFlag("red", true)
		wait(0.1)
		setFlag("red", false)
		wait(0.5)
		setFlag("gunshot", true)
		wait(0.1)
		setFlag("gunshot", false)
		wait(0.7)
		playSound("event:/ui/main/whoosh_large_out", player.Position)
		wait(2.3)
		playSound("event:/char/madeline/mirrortemple_big_landing", player.Position)
		playSound("event:/game/04_cliffside/gondola_finish", player.Position)
		playSound("event:/game/03_resort/clutterswitch_finish", player.Position)
		setFlag("white", true)
		sfxSoundSource1:Play("event:/game/04_cliffside/gondola_halted_loop")
		sfxSoundSource2:Play("event:/moladan/rocketstartfade")
		wait(0.5)
		setFlag("rocket-end", true)
		setFlag("dialog", true)
		for i=0,15,1 do
			alarm(0.2)
		end
		sfxSoundSource1:Stop()
		sfxSoundSource2:Stop()
		playSound("event:/moladan/20210416_Bomb_distant_explosion_-_Sound_Effect", player.Position)
		wait(2.5)
		setFlag("white", false)
		wait(5.0)
		setFlag("teleporting", true)
		wait(30.0)
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		sfxSoundSource1:Stop()
		sfxSoundSource2:Stop()
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("rocket-end", false)
		setFlag("red", false)
		setFlag("white", false)
		setFlag("teleportingskip", true)
		enableMovement()
    end
end