local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()
local sfxSoundSource = celeste.SoundSource()

function onBegin()
	if not getFlag("confrontationWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()

		local salem = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("salem")
		salem.Maxspeed = 30

		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(160, 120), 1.5, 3.0)))
		say("SSC2024_fonda_confrontation01")
		player.ForceCameraUpdate = false
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(42352, -7483), 3.5)))
		walkTo(42544, false, 0.4)
		salem:SetHorizontalScale(1)
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X + 112, salem.Y)))
		salem:PlayAnimation("salemidle")
		wait(0.5)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 2.0, 3.0)))
		wait(3.5)
		say("SSC2024_fonda_confrontation02")
		player.Sprite:Play("walk")
		coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(42534, false, 0.4)))
		wait(0.1)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 2.3, 1.0)))
		salem.Maxspeed = 50
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X + 24, salem.Y)))
		salem:PlayAnimation("salemidle")
		say("SSC2024_fonda_confrontation03")

		player.Sprite:Play("walk")
		coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(42510, false, 2.0)))
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 2.6, 0.5)))
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(42328, -7483), 0.5)))
		playSound("event:/game/06_reflection/badeline_freakout_1", player.Position)
		salem.Maxspeed = 70
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X - 24, salem.Y)))
		salem:PlayAnimation("salemidle")
		say("SSC2024_fonda_confrontation04")
		player.Sprite:Play("walk")
		coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(42486, false, 2.0)))
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 2.9, 0.5)))
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(42304, -7483), 0.5)))
		playSound("event:/game/06_reflection/badeline_freakout_2", player.Position)
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X - 24, salem.Y)))
		salem:PlayAnimation("salemidle")
		say("SSC2024_fonda_confrontation05")
		player.Sprite:Play("walk")
		playSound("event:/game/06_reflection/badeline_freakout_4", player.Position)
		coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(42462, false, 2.0)))
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 3.2, 0.5)))
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(42280, -7483), 0.5)))
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X - 24, salem.Y)))
		salem:PlayAnimation("salemidle")
		say("SSC2024_fonda_confrontation06")

		salem.Maxspeed = 30
		player.Sprite:Play("walk")
		playSound("event:/char/oshiro/boss_enter_screen", player.Position)
		coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(42438, false, 0.7)))
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(42256, -7483), 1.5)))
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X - 32, salem.Y)))
		salem:PlayAnimation("salemidle")
		wait(0.5)
		say("SSC2024_fonda_confrontation07")
		salem:PlayAnimation("salempull")
		wait(1.2)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 2.0, 0.3)))
		playSound("event:/char/badeline/appear", player.Position)
		playSound("event:/char/badeline/temple_move_first", player.Position)
		wait(0.3)
		player.DummyAutoAnimate = false
		player.Sprite:Play("pickup", false)
		wait(1.2)
		say("SSC2024_fonda_confrontation08")
		playSound("event:/game/04_cliffside/gondola_scaryhair_01", player.Position)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 2.3, 0.2)))
		say("SSC2024_fonda_confrontation10")
		playSound("event:/game/04_cliffside/gondola_scaryhair_02", player.Position)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 2.6, 0.2)))
		say("SSC2024_fonda_confrontation11")
		playSound("event:/char/badeline/boss_laser_charge", player.Position)
		playSound("event:/char/oshiro/boss_precharge", player.Position)
		wait(0.7)
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 3.0, 0.2)))
		setFlag("gunshot", true)
		setFlag("gunshotrubble", true)
		playSound("event:/char/badeline/boss_laser_fire", player.Position)
		playSound("event:/char/oshiro/boss_transform_burst", player.Position)
		playSound("event:/game/03_resort/clutterswitch_finish", player.Position)
		playSound("event:/new_content/game/10_farewell/lightning_strike", player.Position)
		playSound("event:/game/04_cliffside/gondola_scaryhair_03", player.Position)
		player.Sprite:Play("tired", true)
		setFlag("red", true)
		wait(0.1)
		setFlag("red", false)
		setFlag("gunshot", false)
		wait(0.5)
		say("SSC2024_fonda_confrontation12")

		sfxSoundSource:Play("event:/game/00_prologue/bridge_rumble_loop")
		setFlag("rubble", true)
		wait(1.5)
		say("SSC2024_fonda_confrontation13")
		salem:PlayAnimation("salemnogun")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(160, 120), 2.0, 1.5)))
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(42256, -7576), 3.0)))
		wait(3.0)
		setFlag("rubble1", true)
		wait(0.7)
		setFlag("rubble2", true)
		wait(0.7)
		setFlag("rubble3", true)
		wait(0.7)
		setFlag("rubble4", true)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(42256, -7483), 2.2)))
		wait(1.5)
		player.DummyAutoAnimate = true
		player.Sprite:Play("idle", true)
		walk(16, true, 1.5)
		wait(0.5)
		say("SSC2024_fonda_confrontation14")
		salem.Maxspeed = 80
		salem:SetHorizontalScale(-1)
		wait(0.2)
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X - 100, salem.Y)))
		walk(10, true, 0.5)
		wait(0.5)
		player.Facing = getEnum("Celeste.Facings", "Right")
		setFlag("rubble5", true)
		wait(0.5)
		walk(100, false, 1.5)
		setFlag("rocket-end", true)
		wait(2.0)
		sfxSoundSource:Stop()
		setFlag("confrontationWatched", true)
		setFlag("teleporting", true)
		wait(30.0)
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		sfxSoundSource:Stop()
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		setFlag("rocket-end", false)
		setFlag("red", false)
		setFlag("confrontationWatched", true)
		setFlag("teleportingskip", true)
		enableMovement()
    end
end