local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

function onBegin()
	if not getFlag("acheronWatched") then
		local level = getLevel()
		local luanet = _G.luanet
		local return_pos = getLevel().Camera.Position
		level:add(coroutineEntity)
		vector = player.Position + vector2(0, 0)
		player.ForceCameraUpdate = true
		disableMovement()
		
		theo = celeste.NPC(player.Position - vector2(20, 0))
		level:Add(theo)
        local sprite = celeste.GFX.SpriteBank:Create("theo")
        theo:Add(sprite)
        theo.Sprite = sprite
		theo.Maxspeed = 60

		local salem = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("salem")
		salem.Maxspeed = 40
		local victor = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("victor")
		victor.Maxspeed = 40

		level:ZoomSnap(vector2(120, 110), 2.0)
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(32000, -4080), 0.1)))
		wait(0.1)
		setFlag("rocket-end", false)
		wait(1.5)
		salem:SetHorizontalScale(1)
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X + 100, salem.Y)))
		salem:PlayAnimation("salemidle")
		wait(0.3)
		salem:SetHorizontalScale(-1)
		victor:PlayAnimation("victorwalk")
		coroutine.yield(victor:MoveTo(vector2(victor.X + 80, victor.Y)))
		victor:PlayAnimation("victoridle")
		wait(1.0)
		say("SSC2024_fonda_acheron01")

		victor:SetHorizontalScale(-1)
		sprite:Play("walk", false, false)
		coroutineEntity:add(monocle.Coroutine(theo:MoveTo(vector2(theo.X + 60, theo.Y))))
		walk(60)
		wait(0.3)
		sprite:Play("idle", false, false)
		wait(1.0)
		say("SSC2024_fonda_acheron02")
		salem:SetHorizontalScale(1)
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X + 16, salem.Y)))
		salem:PlayAnimation("salemidle")
		say("SSC2024_fonda_acheron03")
		salem.Maxspeed = 70
		salem:PlayAnimation("salemwalk")
		coroutine.yield(salem:MoveTo(vector2(salem.X + 80, salem.Y)))
		salem:PlayAnimation("salemidle")
		say("SSC2024_fonda_acheron04")
		wait(0.2)
		victor:SetHorizontalScale(1)
		wait(0.2)
		say("SSC2024_fonda_acheron05")
		salem.Position = vector2(salem.X + 245, salem.Y)
		player.ForceCameraUpdate = false
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(32344, -4080), 4.0)))
		wait(4.5)
		say("SSC2024_fonda_acheron06")
		victor.Position = vector2(victor.X + 235, victor.Y)
		victor:PlayAnimation("victorwalk")
		coroutine.yield(victor:MoveTo(vector2(victor.X + 103, victor.Y)))
		victor:PlayAnimation("victoridle")
		wait(0.5)
		say("SSC2024_fonda_acheron07")
		wait(0.2)
		salem:SetHorizontalScale(-1)
		wait(0.2)
		say("SSC2024_fonda_acheron08")
		player.Position = vector2(player.Position.X + 250, player.Position.Y)
		theo.Position = player.Position
		sprite:Play("walk", false, false)
		player.Sprite:Play("walk")
		coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(player.Position.X + 80, false, 1.0)))
		wait(0.3)
		coroutineEntity:add(monocle.Coroutine(theo:MoveTo(vector2(theo.X + 50, theo.Y))))
		wait(1.0)
		sprite:Play("idle", false, false)
		wait(0.5)
		say("SSC2024_fonda_acheron09")
		coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(32304, -4080), 3.0)))
		wait(3.0)
		say("SSC2024_fonda_acheron10")
		salem:PlayAnimation("salemwalk")
		coroutineEntity:add(monocle.Coroutine(getLevel():ZoomAcross(vector2(120, 110), 2.5, 1.0)))
		coroutine.yield(salem:MoveTo(vector2(player.Position.X + 20, salem.Y)))
		salem:PlayAnimation("salemidle")
		say("SSC2024_fonda_acheron11")
		player.Sprite:Play("walk")
		walk(-16, true, 0.7)
		say("SSC2024_fonda_acheron12")
		sprite:Play("walk", false, false)
		coroutine.yield(theo:MoveTo(vector2(player.Position.X + 16, theo.Y)))
		sprite:Play("idle", false, false)
		say("SSC2024_fonda_acheron13")
		wait(2.0)
		say("SSC2024_fonda_acheron14")
		wait(0.2)
		sprite.Scale = vector2(-1,1)
		wait(0.2)
		say("SSC2024_fonda_acheron15")
		salem:SetHorizontalScale(1)
		salem.Maxspeed = 20
		salem:PlayAnimation("salemwalk")
		coroutineEntity:add(monocle.Coroutine(salem:MoveTo(vector2(salem.X + 40, salem.Y))))
		coroutine.yield(level:ZoomBack(2.0))
		salem:PlayAnimation("salemidle")
		setFlag("acheronWatched", true)
		player.ForceCameraUpdate = true
		enableMovement()
	end
end

function onEnd(room, wasSkipped)
	getLevel():remove(coroutineEntity)
    if wasSkipped then
		player.ForceCameraUpdate = true
		player.DummyAutoAnimate = true
		local victor = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("victor")
		victor.Position = vector2(32464,-3960)
		victor:SetHorizontalScale(1)
		victor:PlayAnimation("victoridle")
		local salem = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("salem")
		salem.Position = vector2(32480,-3960)
		salem:SetHorizontalScale(1)
		salem:PlayAnimation("salemidle")
		theo.Position = vector2(32424,-3944)
		player.Position = vector2(32408,-3960)
		setFlag("rocket-end", false)
		setFlag("acheronWatched", true)
		enableMovement()
    end
end