local vector2 = require("#microsoft.xna.framework.vector2")
local lua_helper = require("#celeste.mod.LuaCutscenes.LuaHelper")
local monocle = require("#monocle")

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function summonSilhouette(position)
  silhouette = celeste.NPC(position)
  getRoom():Add(silhouette)
  local sprite = celeste.GFX.SpriteBank:Create("silhouette")
  silhouette:Add(sprite)
  silhouette.Sprite = sprite
  sprite:Play("idle")
  silhouette.IdleAnim = "idle"
  silhouette.MoveAnim = "walk"
  silhouette.Maxspeed = 46
  silhouette.MoveY = true
end

local function moveSilhouette(xVector, yVector)
  coroutine.yield(silhouette:MoveTo(silhouette.Position + vector2(xVector, yVector)))
end

local function silhouetteWalks()
    wait(0.4)
  moveSilhouette(17, 0)
    wait(0.6)
  moveSilhouette(15, 0)
end

local function silhouetteWalks2()
    wait(0.25)
    moveSilhouette(30, 0)
end

local function silhouettePushes()
    wait(0.4)
end

function onBegin()
    disableMovement()
local room = getRoom()
summonSilhouette(vector2(-1368, -176))
local luanet = _G.luanet
	player.ForceCameraUpdate = true
    getLevel().SaveQuitDisabled = true
    player.DummyAutoAnimate = false
    player.Sprite:Play("downed", true)
    wait(1.5)
    say("SS2024_butcher_intro_3")
    wait(1)
    player.Sprite:Play("getUp", false)
    wait(1)
    player.DummyAutoAnimate = true
    wait(1.5)
  walkCoroutine = makeCoroutine(silhouetteWalks)
  cutsceneEntity:Add(walkCoroutine)
    walk(48)
    wait(1.5)
    helpers.playSound ("event:/char/madeline/footstep")
    walk(17)
    say("SS2024_butcher_intro_4")
    wait(0.25)
    player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Left")
    wait(0.5)
    say("SS2024_butcher_intro_5")
    wait(0.2)
    player.DummyAutoAnimate = false
	helpers.playSound ("event:/char/madeline/theo_collapse")
    player.Speed = vector2(450, 0)
    player.Sprite:Play("roll", false)
    player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Right")
    wait(0.3)
    player.Speed = vector2(0, 0)
    player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Left")
    player.Sprite:Play("dangling", true)
    wait(0.85)
  walk2Coroutine = makeCoroutine(silhouetteWalks2)
  cutsceneEntity:Add(walk2Coroutine)
    say("SS2024_butcher_intro_6")
    wait(0.2)
	helpers.playSound ("event:/game/00_prologue/bridge_support_break")
	helpers.playSound ("event:/game/03_resort/fallblock_wooddistant_impact")
	setFlag("rain_and_wind", false)
	wait(0.1)
	helpers.playSound ("event:/butcherberries_introsting")
	helpers.playSound ("event:/char/madeline/water_in")
	helpers.playSound ("event:/char/madeline/water_dash_in")
    player.DummyAutoAnimate = true
    player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Right")
    makeUnskippable()
    setPlayerState (18, true)
    wait(11.5)
    end

function onEnd(room, wasSkipped)
	if wasSkipped then
        getLevel().SaveQuitDisabled = false
        setColorGrade ("SS2024/butcherberries/blackscreen")
        teleport (50, 0, "DEPTH-1", "WakeUp")
        enableMovement()
end
    teleport (50, 0, "DEPTH-1", "WakeUp")
    setColorGrade ("SS2024/butcherberries/blackscreen")
    enableMovement()
    getLevel().SaveQuitDisabled = false
end