local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")

local function makeCoroutine(func)
    return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function approachNPC()
    player.ForceCameraUpdate = true
    walkTo(6101)
    player.Facing = getEnum("Celeste.Facings", "Left")
    setCameraOffset(0,0)
end

local approachNPCCoroutine

function onTalk()
    disableMovement()
    approachNPCCoroutine = makeCoroutine(approachNPC)
    talker:Add(approachNPCCoroutine)
    if not getFlag("spoken_to_max") then
        setFlag("spoken_to_max", true)
        say("SecretSanta2024_Spooooky_GuestRoomSunsetQuasar")
    else
        say("SecretSanta2024_Spooooky_GuestRoomSunsetQuasar2")
    end
    enableMovement()
end

function onEnd(room, wasSkipped)
    if approachNPCCoroutine then
        approachNPCCoroutine:Cancel()
        talker:Remove(approachNPCCoroutine)
    end
    enableMovement()
end