local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")

local function makeCoroutine(func)
    return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function approachNPC()
    player.ForceCameraUpdate = true
    walkTo(340)
    player.Facing = getEnum("Celeste.Facings", "Right")
    setCameraOffset(0,0)
end

local approachNPCCoroutine

function onTalk()
    disableMovement()
    approachNPCCoroutine = makeCoroutine(approachNPC)
    talker:Add(approachNPCCoroutine)
	if not getFlag("entered_building_a01") then
		if not getFlag("spoken_to_elmer1") then
			setFlag("spoken_to_elmer1", true)
			say("SecretSanta2024_Spooooky_ElmerIntro")
		else
			say("SecretSanta2024_Spooooky_ElmerInsurance")
			setFlag("entered_building_a01", true)
		end
	else
		say("SecretSanta2024_Spooooky_ElmerInsurance2")
	end
    enableMovement()
end

function onEnd(room, wasSkipped)
    if approachNPCCoroutine then
        approachNPCCoroutine:Cancel()
        talker:Remove(approachNPCCoroutine)
    end
    enableMovement()
end