local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")

local function makeCoroutine(func)
    return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function approachNPC()
    player.ForceCameraUpdate = true
    walkTo(430)
    player.Facing = getEnum("Celeste.Facings", "Right")
    setCameraOffset(1,0)
end

local approachNPCCoroutine

function onTalk()
    disableMovement()
    approachNPCCoroutine = makeCoroutine(approachNPC)
    talker:Add(approachNPCCoroutine)
    if not getFlag("SpokenToPurrcilla_flag") then
        setFlag("SpokenToPurrcilla_flag", true)
        say("SecretSanta2024_Spooooky_PurrcillaIntro")
    else
        say("SecretSanta2024_Spooooky_PurrcillaBind")
        if choice("SecretSanta2024_Spooooky_ElytraBindNo", "SecretSanta2024_Spooooky_ElytraBindYes") == 2 then
        coroutine.yield(Celeste.Mod.SantasGifts24.Code.Entities.RebindElytra.RebindElytraButton())
        end
    end
    enableMovement()
end

function onEnd(room, wasSkipped)
    if approachNPCCoroutine then
        approachNPCCoroutine:Cancel()
        talker:Remove(approachNPCCoroutine)
    end
    enableMovement()
end