local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")

local function makeCoroutine(func)
    return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function approachNPC()
    player.ForceCameraUpdate = true
    walkTo(10728)
    player.Facing = getEnum("Celeste.Facings", "Right")
    setCameraOffset(0.5,0)
end

local approachNPCCoroutine

function onTalk()
    disableMovement()
    approachNPCCoroutine = makeCoroutine(approachNPC)
    talker:Add(approachNPCCoroutine)
    if not getFlag("spoken_to_buddy") then
        setFlag("spoken_to_buddy", true)
        say("SecretSanta2024_Spooooky_GuestRoomWorldWaker")
    else
        say("SecretSanta2024_Spooooky_GuestRoomWorldWaker2")
    end
    enableMovement()
end

function onEnd(room, wasSkipped)
    if approachNPCCoroutine then
        approachNPCCoroutine:Cancel()
        talker:Remove(approachNPCCoroutine)
    end
    enableMovement()
end