local drawableSprite = require("structs.drawable_sprite")
local enums = require("consts.celeste_enums")

local obj = {}

obj.name = "ArphimigonHelper/WarpZone"
obj.depth = 100
obj.justification = {0.5, 0.5}
obj.placements = {
    name = "Warp Zone",
    data = {
        spritePath = "decals/2-oldsite/door",
        animRate= 5.0,
        targetRoom = "",
        spawnX = 0,
        spawnY = 0,
	introType = "None",
	wipe = false,
        colorGrade = "",
	flag = "",
    }
}

obj.fieldInformation = {
    introType = {
        options = enums.intro_types
    },
    colorGrade = {
        options = enums.color_grades
    }
}

function obj.sprite(room, entity)
    spriteTemp = drawableSprite.fromTexture(entity.spritePath, entity)
    if spriteTemp == nil then
        spriteTemp = drawableSprite.fromTexture(entity.spritePath .. "0", entity)
    end
    if spriteTemp == nil then
        spriteTemp = drawableSprite.fromTexture(entity.spritePath .. "00", entity)
    end
    return { spriteTemp }
end

return obj