local drawableSprite = require("structs.drawable_sprite")
local enums = require("consts.celeste_enums")

local obj = {}

obj.name = "ArphimigonHelper/Shark"
obj.depth = 100
obj.justification = {0.5, 0.5}
obj.placements = {
    name = "Blahaj",
    data = {
    }
}

obj.fieldInformation = {
    introType = {
        options = enums.intro_types
    },
    colorGrade = {
        options = enums.color_grades
    }
}

function obj.sprite(room, entity)
    spriteTemp = drawableSprite.fromTexture(entity.spritePath, entity)
    if spriteTemp == nil then
        spriteTemp = drawableSprite.fromTexture(entity.spritePath .. "0", entity)
    end
    if spriteTemp == nil then
        spriteTemp = drawableSprite.fromTexture(entity.spritePath .. "00", entity)
    end
    return { spriteTemp }
end

return obj