local drawableSpriteStruct = require("structs.drawable_sprite")
local enums = require("consts.celeste_enums")
local utils = require("utils")

local spinnerConnectionDistanceSquared = 24 * 24

local unknownSpinnerColor = "blue"


local spinner = {}
spinner.name = "ArphimigonHelper/ElementalCrystalSpinner"
spinner.placements = {
    name = "Elemental Crystal Spinner (Arphimigon's Toy Box)",
    data = {
        attachToSolid = false,
    }
}


local function getSpinnerTexture(entity, color, foreground)
    local prefix = (foreground or foreground == nil) and "fg_" or "bg_"

    return "danger/crystal/" .. prefix .. color .. "00"
end

local function 	getSpinnerSprite(entity, foreground)
    -- Prevent color from spinner to tint the drawable sprite
    local color = "white"
    local position = {
        x = entity.x,
        y = entity.y
    }

    local texture = getSpinnerTexture(entity, color, foreground)
    local sprite = drawableSpriteStruct.fromTexture(texture, position)

    if sprite then
        return sprite
    else
        texture = getSpinnerTexture(entity, unknownSpinnerColor, foreground)
        return drawableSpriteStruct.fromTexture(texture, position)
    end
end


function spinner.depth(room, entity)
    return -8500
end

function spinner.sprite(room, entity)
    return getSpinnerSprite(entity)
end

function spinner.selection(room, entity)
    return utils.rectangle(entity.x - 8, entity.y - 8, 16, 16)
end

return spinner