local xnaColors = require("consts.xna_colors")
local lightBlue = xnaColors.LightBlue
local utils = require("utils")

local obj = {}

obj.minimumSize = {8, 8}

obj.name = "Arphimigon/LiminalTileMarker"

obj.placements = {
    name = "Liminal Tile Marker",
    data = {
        color = "FFFFFF",
        width = 4,
        height = 8,
        tiles = "",
        is_fg = true,
        default_tile = '0'
    }
}

obj.fillColor = function(room, entity)
    local color = utils.getColor(entity.color)
    return {color[1] * 0.3, color[2] * 0.3, color[3] * 0.3, 0.6}
end

obj.borderColor = function(room, entity)
    local color = utils.getColor(entity.color)
    return {color[1] * 0.8, color[2] * 0.8, color[3] * 0.8, 0.8}
end

obj.depth = 0

return obj