local obj = {}

obj.name = "ArphimigonHelper/JellySpawner"
obj.depth = 100
obj.justification = {0.5, 0.5}
obj.placements = {
    name = "Jelly Spawner",
    data = {
        bubble = false,
        temporary = false,
        alwaysEnabled = false,
        enabledImagePath = "objects/jellySpawner/base",
        disabledImagePath = "objects/jellySpawner/baseDisabled",
        enabledTemporaryImagePath = "objects/jellySpawner/temporary"
    }
}

function obj.texture(room, entity)
    if entity.temporary then
        return entity.enabledTemporaryImagePath
    elseif entity.alwaysEnabled then
        return entity.enabledImagePath and entity.enabledImagePath or "objects/jellySpawner/base"
    else
        return entity.disabledImagePath and entity.disabledImagePath or "objects/jellySpawner/baseDisabled"
    end
end

return obj