local anchoredSpinnerParent = {}

local spinnerMovementTypes = {
    Track = "Track",
    Wheel = "Wheel",
    Pulse = "Pulse",
}

local pauseTimes = {
    Slow = 0.3,
    Normal = 0.2,
    Fast = 0.6,
}

local moveTimes = {
    Slow = 0.9,
    Normal = 0.4,
    Fast = 0.3,
}

anchoredSpinnerParent.name = "ArphimigonHelper/AnchoredSpinnerParent"

anchoredSpinnerParent.depth = 200
anchoredSpinnerParent.texture = "danger/dustcreature/center00"
anchoredSpinnerParent.justification = {0.5, 0.5}

anchoredSpinnerParent.placements = {
    name = "Spinner Pattern",
    data = {
        spinnerMovementType = "", 
        spinnerCount = 1,
        radius = 40,  
        angleOffset = 0, 
        startPercent = 0, 
        loopTime = 1.8, 
        pulsePower = 0.5, 
        clockwise = false, 
        gaps = "", 
        pauseTime = 0.2, 
        moveTime = 0.3, 
        trackOffsetX = 0, 
        trackOffsetY = 0
    }
}

anchoredSpinnerParent.fieldInformation = {
    spinnerMovementType = {
        options = spinnerMovementTypes,
        editable = false
    },
    pauseTime = {
        options = pauseTimes,
        editable = true
    },
    moveTime = {
        options = moveTimes,
        editable = true
    }
}

return anchoredSpinnerParent
