local drawableSprite = require('structs.drawable_sprite')
local enums = require("consts.celeste_enums")
local utils = require("utils")
local math = require("math")

local sideIndexLookup = {
    "Up",
    "Right",
    "Down",
    "Left",

    Up = 1,
    Right = 2,
    Down = 3,
    Left = 4
}

local function createNeedle(truename,displayname,rotation,mini)
    local NeedleEntity = {}
    
    NeedleEntity.name = truename
    NeedleEntity.fieldInformation = {
        hitbox = {
        options = {"NeedleHelper", "Forgiving", "Unforgiving"},
        editable = false
        },
        isMini = {
            fieldType = "boolean",
            default = false
        }
    }

    NeedleEntity.offset = function(room, entity) return entity.isMini and {0.5, 0.5} or {0, 0} end

    NeedleEntity.placements = {
        {
            name = displayname,
            data = {
                Sprite = (mini and "MiniNeedleEntity" or "NeedleEntity"),
                hitbox = "NeedleHelper",
                isMini = mini
            }
        }
    }

    NeedleEntity.sprite = function(room,entity)
        local sprite 
        local spritepath = (entity.isMini and "/mini00" or "/needle00")
        sprite = drawableSprite.fromTexture("danger/toehou/".."NeedleEntity"..spritepath, entity)
        sprite.rotation = math.rad(90*(rotation-1))
        return sprite
    end

    function NeedleEntity.rotate(room, entity, direction)
        local newFacing = utils.mod1(rotation + direction,4)
        entity._name = "toehou/"..(entity.isMini and "MiniNeedle" or "Needle")..sideIndexLookup[newFacing]
        return true
    end


    return NeedleEntity
end

local NeedleEntityUp = createNeedle("toehou/NeedleUp","Needle (Up)",1,false)
local NeedleEntityDown = createNeedle("toehou/NeedleDown","Needle (Down)",3,false)
local NeedleEntityRight = createNeedle("toehou/NeedleLeft","Needle (Left)",4,false)
local NeedleEntityLeft =  createNeedle("toehou/NeedleRight","Needle (Right)",2,false)

local miniNeedleEntityUp = createNeedle("toehou/MiniNeedleUp","Mini Needle (Up)",1,true)
local miniNeedleEntityDown = createNeedle("toehou/MiniNeedleDown","Mini Needle (Down)",3,true)
local miniNeedleEntityRight = createNeedle("toehou/MiniNeedleLeft","Mini Needle (Left)",4,true)
local miniNeedleEntityLeft =  createNeedle("toehou/MiniNeedleRight","Mini Needle (Right)",2,true)


return {
    NeedleEntityUp,
    NeedleEntityDown,
    NeedleEntityLeft,
    NeedleEntityRight,
    miniNeedleEntityUp,
    miniNeedleEntityDown,
    miniNeedleEntityRight,
    miniNeedleEntityLeft}