--- Showing off callbacks available in the talker and brief explanations.
-- You are not required to define anything you aren't using.
-- Leave callbacks global to automatically detect it on c# side.
-- This assumes you know your way around Lua, if you don't then <a href=https://www.lua.org/pil/5.1.html>please consider reading the Lua PIL</a>.
-- <h2>Setting up in map editor</h2>
-- In the case of this talker, the filename for the entity field is "Assets/LuaCutscenes/example_talker".
-- Please use your own folders for your own talkers, like any other Celeste asset collisions can happen.<br>
-- <h2>Using C# in talker</h2>
-- Any imports from C# can be done with prefixing # in the require string. For example `local celeste = require("#Celeste")`.<br>
-- Check out helper_functions.lua for examples on C# interaction.
-- @module example_talker

--- Coroutine that is called when talker is interacted with.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onTalk()
    walk(5)
    wait(0.5)
    walk(-5)
    wait(0.5)
    say("APHYLLIX_BUFFER1_CHOICEINTRO")

    -- The new way of doing choices, recommended.
    -- It accepts a table containing information about all possible choices and their requirements.
    choiceDialog({
        -- The most basic dialog choice.
        -- The dialog key DIALOG_1 will be used for displaying the choice, then when you choose it, the dialog DIALOG_1_SAY will be shown.
        {
            -- This choice will not display a dialog, and instead run the code in 'onChosen'
            "APHYLLIX_BUFFER1_CHOICEONE",
            onChosen = function ()
                setMusicLayer(2, false)
                wait(1.7)
                setFlag("zoomenvelop", true)
                wait(3.5)
                setFlag("envelop", true)
                wait(0.5)
                setFlag("enveloptwo", true)
                wait(0.3)
                setFlag("envelopthree", true)
                wait(0.5)
                setFlag("envelopfour", true)
                instantTeleportTo(18102, 336, "a")
                waitUntilOnGround()
                closeChoiceDialog()
            end
        },
        {
            -- this choice will still display a dialog like normal, but also run code in 'onEnd' after the dialog finishes.
            "APHYLLIX_BUFFER1_CHOICETWO",
            onEnd = function ()
                -- call this function to close the choice dialog and allow the cutscene to continue.
                closeChoiceDialog()
            end
        }
    })

    enableMovement()
end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
    -- Skipping cutscenes is rude, you know :/
    if wasSkipped then
        die()
    end
end