local flagClutterDoor = {}

local variantOptions = {
    Laundry = "red",
    Books = "green",
    Boxes = "yellow",
}


flagClutterDoor.name = "DSModHelper/FlagControlledClutterDoor"
flagClutterDoor.depth = 100
flagClutterDoor.texture = "collectables/heartGem/3/00"
flagClutterDoor.justification = {0.5, 0.5}
flagClutterDoor.placements = {
    name = "Flag Controlled Clutter Door (DSModHelper)",
    data = {
        width = 24, 
        height = 24,
        type = "green", 
        flagName = ""
    }
}
flagClutterDoor.fieldInformation = {
    type = {
        options = variantOptions,
        editable = false
    }
}

function flagClutterDoor.texture(room, entity)
    local variant = entity.type
    local drawableRectangleSprites = drawableRectangle.fromRectangle("bordered", rectangle, fillColor, borderColor):getDrawableSprite()
    local iconSprite = string.format("objects/resortclutter/icon_%s", string.lower(variant))
    local doorSprite = drawableSprite.fromTexture(doorTexture, entity)

    local width, height = entity.width or 24, entity.height or 24
    doorSprite:addPosition(math.floor(width / 2), math.floor(height / 2))
    return sprite
end

return flagClutterDoor