local WaterSwitchGate = {}
local lib = require("mods").requireFromPlugin("libraries.SelfishHelper")

local drawableNinePatch = require("structs.drawable_nine_patch")
local drawableSprite = require("structs.drawable_sprite")
local drawableRectangle = require("structs.drawable_rectangle")

WaterSwitchGate.name = "SelfishHelper/WaterSwitchGate"
WaterSwitchGate.depth = 8998
WaterSwitchGate.canResize = {true, true}
WaterSwitchGate.nodeLimits = {1, 1}
WaterSwitchGate.fieldOrder = lib.waterBlockFieldOrder
WaterSwitchGate.placements = {
	{
		name = "normal",
		data = {
			width = 8,
			height = 8,
			movePlayer = false,
			legacyMovePlayer = false,
			topTension = false,
			bottomTension = false,
			leftTension = false,
			rightTension = false,
			persistent = false
		},
		--placementType = "rectangle"
	},
	{
		name = "movePlayer",
		data = {
			width = 8,
			height = 8,
			movePlayer = true,
			legacyMovePlayer = false,
			topTension = false,
			bottomTension = false,
			leftTension = false,
			rightTension = false,
			persistent =  false
		},
		--placementType = "rectangle"
	}
}
local fillColor = lib.fillColor
local borderColor = lib.borderColor

function WaterSwitchGate.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 24, entity.height or 24
    local sprites = {}
	
    local centerSprite = drawableSprite.fromTexture("objects/switchgate/icon00", entity)
	local rectangle = drawableRectangle.fromRectangle("bordered", x, y, width, height, fillColor, borderColor)

    centerSprite:addPosition(math.floor(width / 2), math.floor(height / 2))
	table.insert(sprites, rectangle)
    table.insert(sprites, centerSprite)

    return sprites
end

return WaterSwitchGate