local WaterSwapBlock = {}
local lib = require("mods").requireFromPlugin("libraries.SelfishHelper")
local lightBlue = lib.lightBlue

local drawableNinePatch = require("structs.drawable_nine_patch")
local drawableSprite = require("structs.drawable_sprite")
local drawableRectangle = require("structs.drawable_rectangle")
local utils = require("utils")

WaterSwapBlock.name = "SelfishHelper/WaterSwapBlock"
WaterSwapBlock.depth = 8998
WaterSwapBlock.canResize = {true, true}
WaterSwapBlock.nodeLimits = {1, 1}
WaterSwapBlock.fieldOrder = lib.waterBlockFieldOrder
WaterSwapBlock.placements = {
    lib.waterBlockNormal,
	lib.waterBlockMovePlayer
}

local ninePatchOptions = {
    mode = "fill",
    borderMode = "repeat",
    fillMode = "repeat"
}

local trailNinePatchOptions = {
    mode = "fill",
    borderMode = "repeat",
    useRealSize = true
}


local fillColor = lib.fillColor
local borderColor = lib.borderColor

local function addTrailSprites(sprites, entity)
    local nodes = entity.nodes or {}
    local x, y = entity.x or 0, entity.y or 0
    local nodeX, nodeY = nodes[1].x or x, nodes[1].y or y
    local width, height = entity.width or 8, entity.height or 8
    local drawWidth, drawHeight = math.abs(x - nodeX) + width, math.abs(y - nodeY) + height
	local trailTexture = "objects/SelfishHelper/waterSwapBlock/target"

    x, y = math.min(x, nodeX), math.min(y, nodeY)

    if path then
        local pathDirection = x == nodeX and "V" or "H"
        local pathTexture = string.format("objects/swapblock/path%s", pathDirection)
        local pathNinePatch = drawableNinePatch.fromTexture(pathTexture, pathNinePatchOptions, x, y, drawWidth, drawHeight)
        local pathSprites = pathNinePatch:getDrawableSprite()

        for _, sprite in ipairs(pathSprites) do
            sprite.depth = pathDepth

            table.insert(sprites, sprite)
        end
    end

    local frameNinePatch = drawableNinePatch.fromTexture(trailTexture, trailNinePatchOptions, x, y, drawWidth, drawHeight)
    local frameSprites = frameNinePatch:getDrawableSprite()

    for _, sprite in ipairs(frameSprites) do
        sprite.depth = trailDepth

        table.insert(sprites, sprite)
    end
end

local function addBlockSprites(sprites, entity, position)
    local x, y = math.floor(position.x or 0), position.y or 0
    local width, height = entity.width or 24, entity.height or 24

    local blockTexture, middleTexture = "objects/SelfishHelper/waterSwapBlock/blockRed", "objects/SelfishHelper/waterSwapBlock/midBlockRed00"

    local ninePatch = drawableNinePatch.fromTexture(blockTexture, ninePatchOptions, x, y, width, height)
	
    local middleSprite = drawableSprite.fromTexture(middleTexture, position)
    middleSprite:addPosition(math.floor(width / 2), math.floor(height / 2))
	
	local rectangle = drawableRectangle.fromRectangle("bordered", x, y, width, height, fillColor, borderColor)
	
	table.insert(sprites, rectangle)
	for _, sprite in ipairs(ninePatch:getDrawableSprite()) do
        table.insert(sprites, sprite)
    end
    table.insert(sprites, middleSprite)
end

function WaterSwapBlock.sprite(room, entity)
    local sprites = {}
	addTrailSprites(sprites, entity)
	addBlockSprites(sprites, entity, entity)
    return sprites
end

function WaterSwapBlock.nodeSprite(room, entity, node)
	local sprites = {}
	addBlockSprites(sprites, entity, node)
    return sprites
end

function WaterSwapBlock.selection(room, entity)
    local nodes = entity.nodes or {}
    local x, y = entity.x or 0, entity.y or 0
    local nodeX, nodeY = nodes[1].x or x, nodes[1].y or y
    local width, height = entity.width or 8, entity.height or 8

    return utils.rectangle(x, y, width, height), {utils.rectangle(nodeX, nodeY, width, height)}
end

return WaterSwapBlock