local WaterMoveBlock = {}

local lib = require("mods").requireFromPlugin("libraries.SelfishHelper")

local drawableNinePatch = require("structs.drawable_nine_patch")
local drawableSprite = require("structs.drawable_sprite")
local drawableRectangle = require("structs.drawable_rectangle")

WaterMoveBlock.name = "SelfishHelper/WaterMoveBlock"
WaterMoveBlock.depth = 8998
WaterMoveBlock.canResize = {true, true}
WaterMoveBlock.fieldInformation = {
	direction = {
		options = {
			Left = "Left",
			Right = "Right",
			Down = "Down",
			Up = "Up"
		},
		editable = false
	}
}
WaterMoveBlock.fieldOrder = lib.waterBlockFieldOrder
WaterMoveBlock.placements = {
	{
		name = "normal",
		data = {
			width = 8,
			height = 8,
			movePlayer = false,
			legacyMovePlayer = false,
			topTension = false,
			bottomTension = false,
			leftTension = false,
			rightTension = false,
			direction = "Left",
			fast = false
		},
	},
	{
		name = "movePlayer",
		data = {
			width = 8,
			height = 8,
			movePlayer = true,
			legacyMovePlayer = false,
			topTension = false,
			bottomTension = false,
			leftTension = false,
			rightTension = false,
			direction = "Left",
			fast = false
		},
	}
}

local ninePatchOptions = {
    mode = "fill",
    borderMode = "repeat",
    fillMode = "repeat"
}

local fillColor = lib.fillColor
local borderColor = lib.borderColor

local arrowTextures = {
	Left = "objects/SelfishHelper/waterMoveBlock/arrow04",
	Right = "objects/SelfishHelper/waterMoveBlock/arrow00",
	Down = "objects/SelfishHelper/waterMoveBlock/arrow06",
	Up = "objects/SelfishHelper/waterMoveBlock/arrow02"
}

function WaterMoveBlock.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 24, entity.height or 24

    local blockTexture, arrowTexture = "objects/SelfishHelper/waterMoveBlock/base", arrowTextures[entity.direction]

    local ninePatch = drawableNinePatch.fromTexture(blockTexture, ninePatchOptions, x, y, width, height)
    local arrowSprite = drawableSprite.fromTexture(arrowTexture, entity)
    local sprites = {}
	
	local rectangle = drawableRectangle.fromRectangle("bordered", x, y, width, height, fillColor, borderColor)

    arrowSprite:addPosition(math.floor(width / 2), math.floor(height / 2))
	ninePatch:setColor(borderColor)
	arrowSprite:setColor(borderColor)
	table.insert(sprites, rectangle)
	for _, sprite in ipairs(ninePatch:getDrawableSprite()) do
        table.insert(sprites, sprite)
    end
    table.insert(sprites, arrowSprite)

    return sprites
end

WaterMoveBlock.texture = "objects/SelfishHelper/waterMoveBlock/arrow04"


return WaterMoveBlock