local WaterGoldenBlock = {}
local lib = require("mods").requireFromPlugin("libraries.SelfishHelper")

local drawableNinePatch = require("structs.drawable_nine_patch")
local drawableSprite = require("structs.drawable_sprite")
local drawableRectangle = require("structs.drawable_rectangle")

WaterGoldenBlock.name = "SelfishHelper/WaterGoldenBlock"
WaterGoldenBlock.depth = 8998
WaterGoldenBlock.canResize = {true, true}
WaterGoldenBlock.fieldOrder = lib.waterBlockFieldOrder
WaterGoldenBlock.placements = {
    lib.waterBlockNormal,
	lib.waterBlockMovePlayer
}
local fillColor = lib.fillColor
local borderColor = lib.borderColor

function WaterGoldenBlock.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 24, entity.height or 24
    local sprites = {}
	
    local centerSprite = drawableSprite.fromTexture("objects/switchgate/icon00", entity)
	local rectangle = drawableRectangle.fromRectangle("bordered", x, y, width, height, fillColor, borderColor)

    centerSprite:addPosition(math.floor(width / 2), math.floor(height / 2))
	table.insert(sprites, rectangle)
    table.insert(sprites, centerSprite)

    return sprites
end

return WaterGoldenBlock