local enums = require("consts.celeste_enums")
local utils = require("utils")

local badheoBoss = {}

badheoBoss.name = "RestlessDays/BadheoBoss"
badheoBoss.depth = 0
badheoBoss.nodeLineRenderType = "line"
badheoBoss.texture = "characters/AnEnormousSmileyFace/RestlessDays/badheoBoss/charge00"
badheoBoss.nodeLimits = {0, -1}
badheoBoss.fieldInformation = {
    patternIndex = {
        fieldType = "integer",
        options = enums.badeline_boss_shooting_patterns,
        editable = false
    }
}
badheoBoss.placements = {
    name = "Badheo Boss",
    data = {
        patternIndex = 1,
    }
}
function badheoBoss.selection(room, entity)
    local main = utils.rectangle(entity.x - 19, entity.y - 13, 38, 30)
    local nodes = {}

    if entity.nodes then
        for i, node in ipairs(entity.nodes) do
            nodes[i] = utils.rectangle(node.x - 19, node.y - 13, 38, 30)
        end
    end

    return main, nodes
end

return badheoBoss
