local monocle = require("#monocle")
local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local vector2 = require("#microsoft.xna.framework.vector2")


local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

function onBegin()
    wiggle_coroutine = makeCoroutine(wiggler)
    cutsceneEntity:Add(wiggle_coroutine)
    disableMovement()
    wait(0.5)
    setFlag("darkness_fade", false)
    wait(2)
    playSound("event:/AnEnormousSmileyFace/no-rest-phone")
    wait(3.8)
    playSound("event:/game/02_old_site/sequence_phone_pickup")
    wait(0.05)
    playSound("event:/game/02_old_site/sequence_phone_pickup")
    wait(0.5)
    miniTextbox("AnEnormousSmileyFace_RestlessDays_boss_overtime")
    wait(4.7)
    miniTextbox("AnEnormousSmileyFace_RestlessDays_madeline")
    wait(3)
    setFlag("darkness_fade", true)
    wait(7)
end

function wiggler()
    pos_x = 1000
    y_min = -272
    y_max = -110
    y_curr = -272
    dir = 1
    while (true) do
        y_curr = y_curr + dir
        player.Position = vector2(pos_x, y_curr)
        if (y_curr >= y_max) then
            dir = -1
        elseif (y_curr <= y_min) then
            dir = 1
        end
        wait()
    end
end

function onEnd()
    if wiggle_coroutine then
        wiggle_coroutine:Cancel()
        cutsceneEntity:Remove(wiggle_coroutine)
    end
    instantTeleportTo(1160, -376, "END-04")
end
