local celeste = require("#celeste")
local monocle = require("#monocle")


function onBegin()

    -- Some neat variables
    local level = getLevel()
    
    -- Disable controls
    disableMovement()
    disablePause()

    -- Activates black screen
    setFlag("Typorium_PerchoirsBirthday_FallLobby_BlackScreen", true)

    -- Waits two seconds
    wait(2)

    -- Moves camera instantly
    local camera_original_position = level.Camera.Position
    local camera_zoomto_position = vector2(
        700 - 160,
        -920 - 90
    )
    coroutine.yield(celeste.CutsceneEntity.CameraTo(camera_zoomto_position, 0, monocle.Ease.SineInOut))
    
    -- Deactivates black screen
    setFlag("Typorium_PerchoirsBirthday_FallLobby_BlackScreen", false)
    wait(5)

    -- Reactives black screen
    setFlag("Typorium_PerchoirsBirthday_FallLobby_BlackScreen", true)
    wait(2)

    -- Moves back instantly
    coroutine.yield(celeste.CutsceneEntity.CameraTo(camera_original_position, 0, monocle.Ease.SineInOut))

    -- Enables controls
    setFlag("Typorium_PerchoirsBirthday_FallLobby_BlackScreen", false)
    enableMovement()
    enablePause()
end

function onEnd(room, wasSkipped)

    -- Some neat variables
    local level = getLevel()

    -- Restore camera
    level:ResetZoom()

    -- Deactivates black screen
    setFlag("Typorium_PerchoirsBirthday_FallLobby_BlackScreen", false)

    -- Enables controls
    enableMovement()
    enablePause()

end

function onEnter(player)
end

function onStay(player)
end

function onLeave(player)
end