// #version 300 es

// precision highp float;
// precision highp sampler2D;

// in float2 uv;
// out float4 out_color;

// uniform float2 u_resolution;
// uniform float u_time;
// uniform float4 u_mouse;
// uniform sampler2D u_textures[16];

// float3 SunColorCurve(float time) {
//     return lerp(float3(0.75,0.5,0.25), float3(1,0.25,0), time);// * (1.0 - 1.0 * pow(time, 9.0));
// }

// float2 WrapUv(float2 uv) {
//     return mod(-uv + float2(10000,10000), 1.0);
// }

// float4 Water(float2 uv, float3 pos) {
//     float Time = u_time;
//     float3 CamPos = float3(u_time,0,0);
//     float2 Dimensions = float2(1,1);

//     float angle = 0.0;

//     float height = pos.z;
//     float depth = height/(uv.y - 0.5);
//     float2 pointPosition = float2((uv.x - 0.5) * depth, depth);
    
//     pointPosition *= mat2(cos(-angle), -sin(-angle), sin(-angle), cos(-angle));
//     pointPosition += pos.xy;

//     if(depth > 0.0) {
//         return float4(0,0,0,0);
//     }

//     float value1 = SAMPLE_TEXTURE(text, WrapUv(pointPosition * float2(1.2,3.2) + float2(Time/5.12894, Time/20.2))).r;
//     float value2 = SAMPLE_TEXTURE(text, WrapUv(pointPosition * float2(1,2) + float2(-Time/6.2915, 0.0))).r;

//     float4 mixed = (
//         lerp(float4(0.1,0.4,0.6,1), float4(0.4,0.9,1.0,1), value1) * 0.5 + 
//         lerp(float4(0.2,0.3,0.6,1), float4(0.4,0.7,0.8,1), value2) * 0.5
//     );

//     // return lerp(mixed, float4(1,1,1,1), 0.6 - 0.6 / (0.0 - depth));
//     // return lerp(mixed, float4(1,0.4,0.5,1), 0.7 - 0.7 / (0.0 - depth * 2.0));
//     mixed.xyz += SunColorCurve(u_mouse.x / u_resolution.x) * pow(mixed.g, 0.25) * 1.0 * exp(-pow((pointPosition.x + (value1 - value2) * 0.25 - pos.x) * 4.0 / pow(-pointPosition.y, 1.0), 2.0));
    
//     return lerp(mixed, float4(1,1,1,1), 0.6 - 0.6 / (0.0 - depth));
// }

// float4 Sky(float2 uv, float3 pos) {
//     if(uv.y > 0.5) return float4(0);

//     float3 sun = SunColorCurve(u_mouse.x / u_resolution.x);

//     float3 baseSky = lerp(lerp(float3(0.2,0.4,1), float3(0.6,0.7,1), 2.0 * uv.y), float3(0,0,0), u_mouse.x / u_resolution.x * 0.25);
//     float y = pow(2.0 * (uv.y - 0.5) + 1.0, 4.0);
//     float cloud1 = SAMPLE_TEXTURE(text, float2((uv.x - u_time * 0.2 - pos.x * 0.1) * 0.5, y)).r;
//     float cloud2 = SAMPLE_TEXTURE(text, float2((uv.x + u_time * 0.2 - pos.x * 0.1) * 0.5, 1.0 - y)).r;

//     // float sunGlow = max(1.0 - 8.0 * distance(uv, float2(0.5)), 0.0) * 0.5;
//     float distanceToSun = distance(uv, float2(0.5, 0.3 + 0.22 * u_mouse.x / u_resolution.x));
//     float sunGlow = exp(-pow(distanceToSun * 25.0, 2.0)) * 0.5;

//     return float4(lerp(baseSky, lerp(sun, float3(1,1,1), 0.7), pow(cloud1, 2.0) * 1.0 + pow(cloud2, 2.0) * 1.0) + float3(1,1,0.7) * sunGlow, 1);
// }

// float4 Sample(float2 uv) {
//     float Time = u_time;
//     float3 CamPos = float3(u_time,0,0);
//     float2 Dimensions = float2(1,1);
//     float3 pos = float3((-CamPos.x / Dimensions.x) * 0.3, 0, -0.3 + sin(u_time) * 0.1);
//     // float4 composite = Water(uv, pos);
//     float4 composite = Sky(uv, pos) + Water(uv, pos);

//     for(float i = 1.0; i < 3.0; i++) {
//         float value = SAMPLE_TEXTURE(text, WrapUv(uv * i + float2(Time * 0.2 * (mod(i, 2.0) * 2.0 - 1.0), 0.0) + float2(-1, 1) * pos.xz)).r;

//         composite = lerp(composite, float4(lerp(float3(1,1,1), SunColorCurve(u_mouse.x / u_resolution.x), u_mouse.x / u_resolution.x * 0.5),1), value * (0.4 / i));
//     }

//     return composite;
// }

#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new floattor2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float3 SunColorCurve(float time) {
    return time < 1.0 ? lerp(float3(0.75,0.5,0.25), float3(1,0.25,0), time) : lerp(float3(1,0.25,0), float3(0.7,0.4,0.8), time - 1.0);// * (1.0 - 1.0 * pow(time, 9.0));
}

float2 WrapUv(float2 uv) {
    return (-uv + float2(10000,10000)) % 1;
}

float4 Sky(float2 uv, float3 pos, float sunStage) {
    if(uv.y > 0.5) return float4(0,0,0,0);

    float3 sun = SunColorCurve(sunStage);

    float3 baseSky = lerp(lerp(float3(0.2,0.4,1), float3(0.6,0.7,1), 2.0 * uv.y), float3(0,0,0), sunStage * 0.25);
    float y = pow(1.5 * (uv.y - 0.5) + 1.0, 4.0);
    float cloud1 = SAMPLE_TEXTURE(text, WrapUv(float2((uv.x - Time * 0.2 - pos.x * 0.1) * 0.5, y))).r;
    float cloud2 = SAMPLE_TEXTURE(text, WrapUv(float2((uv.x + Time * 0.2 - pos.x * 0.1) * 0.5, 1.0 - y))).r;

    // float sunGlow = max(1.0 - 8.0 * distance(uv, float2(0.5)), 0.0) * 0.5;
    float distanceToSun = distance(uv * float2(Dimensions.x / Dimensions.y, 1.0) - 0.5 * float2(Dimensions.x / Dimensions.y - 1, 0.0), float2(0.5, 0.3 + 0.15 * sunStage));
    float sunGlow = exp(-pow(distanceToSun * 25.0, 2.0)) * 0.5;

    return float4(lerp(baseSky, lerp(sun, float3(1,1,1), 0.7), pow(cloud1, 2.0) * 1.0 + pow(cloud2, 2.0) * 1.0) + float3(1,1,0.7) * sunGlow, 1);
}

float4 Sample(float2 uv) {
    float3 pos = float3(0, 0, -0.2) + float3(-CamPos.x / Dimensions.x, 0, CamPos.y / Dimensions.y) * 0.3;
    float sunStage = CamPos.x / Dimensions.x / 50.0;
    if(sunStage > 1.0) sunStage = (sunStage - 1.0) / 2.25 + 1.0;
    float4 composite = Sky(uv, pos, sunStage);

    float fac = 1.5 - 0.5 * sunStage;

    if(fac < 0.0) fac = 0.0;
    if(fac > 1.0) fac = 1.0;

    return composite * fac;
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0 {
    return (
        Sample(uv + float2(+0.25 / Dimensions.x, +0.25 / Dimensions.y)) + 
        Sample(uv + float2(-0.25 / Dimensions.x, +0.25 / Dimensions.y)) + 
        Sample(uv + float2(+0.25 / Dimensions.x, -0.25 / Dimensions.y)) + 
        Sample(uv + float2(-0.25 / Dimensions.x, -0.25 / Dimensions.y))
    ) * 0.25;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}