using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Monocle;

namespace Celeste.Mod.teleportingEsoterically.Entities
{
    [CustomEntity("teleportingEsoterically/RoomClearController")]
    [Tracked]
    public class RoomClearController : Entity
    {
        public string switchflag;
        public string rejectionflag;
        public string checkflags;
        public string checkflagsafterswitchflag;
        public string flagstodingaling;
        public string audioevents;
        public bool reject;
        public string roomcolor;
        public string room;

        public RoomClearController(EntityData data, Vector2 offset)
            : base(data.Position + offset)
        {
            switchflag = data.Attr("SwitchFlag");
            checkflags = data.Attr("FlagsToCheck","");
            checkflagsafterswitchflag = data.Attr("FlagsToCheckAfterSwitchFlag");
            flagstodingaling = data.Attr("SoundFlags","");
            audioevents = data.Attr("AudioEvents","");
            rejectionflag = data.Attr("RejectionFlag","");
            reject = data.Bool("Reject",true);
            roomcolor = data.Attr("RoomColor","White");
            room = data.Attr("Room", "");
        }



        public override void Update()
        {
            Level level = base.Scene as Level;
            string flagstocheck = (level.Session.GetFlag(switchflag) ? checkflagsafterswitchflag : checkflags);
            if (level == null || !reject || flagstocheck == "" || flagstocheck == null) return;
            foreach (string i in flagstocheck.Split(','))
            {
                if (!level.Session.GetFlag(i))
                {
                    level.Session.SetFlag(rejectionflag, true);
                    return;
                }
            }
            base.Update();
        }

    }

}