local modName = modMetaData.Name

local function dbg(s)
    log(s, "NeonWave")
end

local function forEach(enumerable, f)
    local em = enumerable:GetEnumerator()
    while em:MoveNext() do
        f(em.Current)
    end
end

local function any(enumerable, f)
    local em = enumerable:GetEnumerator()
    while em:MoveNext() do
        if f(em.Current) then
            return true
        end
    end
    return false
end

local function removeEntity(room, id)
    getSession().DoNotLoad:Add(celeste.EntityID(room, id))
end

local function addEntity(room, id)
    getSession().DoNotLoad:Remove(celeste.EntityID(room, id))
end

local function getType(name, prefix)
    return celeste.Mod[modName].MethodWrappers.GetTypeFromString(name, prefix)
end

function onStay()
    hasGolden = any(player.Leader.Followers, (function(e)
        return getType("Strawberry"):IsInstanceOfType(e.Entity) and e.Entity.Golden
    end))
    setFlag("memorial-normal.f0", hasGolden)
    if hasGolden then
        addEntity("memorial-golden", 736)
    end
end

-- function onEnter()
--     dbg(1)
--     dbg(getSession().MapData.Levels.Count)
--     forEach(getSession().MapData.Levels, function(l)
--         dbg(l.Name)
--         forEach(l.Entities, function(e)
--             dbg(e.Name)
--         end)
--     end)
--     dbg(2)
-- end
