local Ease = require("#Monocle.Ease")

local function doFadeWipe1(state)
  fadeWipe = celeste.FadeWipe(engine.Scene, state, nil)
  engine.Scene:Add(fadeWipe)
  fadeWipe.duration = 20
  fadeWipe.EndTimer = 0
end

local function doFadeWipe2(state)
  fadeWipe = celeste.FadeWipe(engine.Scene, state, nil)
  engine.Scene:Add(fadeWipe)
  fadeWipe.duration = 1.5
  fadeWipe.EndTimer = 3
end


function onBegin()

  if not getFlag("introstart") then

    intro = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("introwhitespace")
    --intro.Position = vector2(160, 94)
    intro:PlayAnimation("blackscreen")
    disableMovement()
    player.DummyAutoAnimate = false
    player.ForceCameraUpdate = false
    coroutine.yield(celeste.cutsceneEntity.CameraTo(player.Position + vector2(-160, -700), 0, Ease.Linear, 0))
    wait(5)

    playMusic("event:/CBR_WanderBDay_intro")
    wait(2)

    doFadeWipe1(true)
    wait()

    intro:PlayAnimation("intro1")
    wait(11)

    intro:PlayAnimation("intro2")
    wait(5)

    intro:PlayAnimation("intro3")
    wait(5)

    intro:PlayAnimation("intro4")
    wait(4)

    intro:PlayAnimation("intro5")
    wait(6)

    intro:PlayAnimation("intro6")
    wait(6)

    playMusic("null")
    intro:PlayAnimation("blackscreen")
    wait(1)

    doFadeWipe2(true)
    coroutine.yield(celeste.cutsceneEntity.CameraTo(player.Position + vector2(-160, -700), 0, Ease.Linear, 0))
    intro:RemoveSelf()
    wait(3)

    setFlag("musicwhitespace", true)
    player.Sprite:Play("asleep", false, false)
    coroutine.yield(celeste.cutsceneEntity.CameraTo(player.Position + vector2(-160, -164), 10, Ease.Linear, 2))
    wait(1)

    player.Sprite:Play("wakeup", true, false)
    wait(2.5)

    player.ForceCameraUpdate = true
    player.DummyAutoAnimate = true
    setFlag("introstart")
    enableMovement()
    setFlag("desparar")

  end

end

function onEnd(wasSkipped)

  if wasSkipped then

    if not getFlag("introstart") then

    intro:RemoveSelf()
    setFlag("musicwhitespace", true)
    setFlag("introstart")
    player.Sprite:Play("idle", true, false)
    player.ForceCameraUpdate = true
    player.DummyAutoAnimate = true
    enableMovement()
    setFlag("desparar")

    end

  end

end