local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local Ease = require("#Monocle.Ease")

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function camera()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(-11684, -6373), 4, Ease.ExpoOut, 0))
end


function onBegin()

  if not getFlag("monstro5") then

  stranger = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("stranger")

  disableMovement()
  player.ForceCameraUpdate = false
  waitingCoroutine = makeCoroutine(camera)
  cutsceneEntity:Add(waitingCoroutine)
  wait(1)

  coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CelesteBrasil_wanderbirthdaymap_eu"))
  wait(0.5)

  playSound("event:/char/badeline/disappear", stranger.Position)
  getRoom().Displacement:AddBurst(stranger.Position + vector2(0, 0), 0.5, 12, 48, 1.4, nil, nil)
  getLevel().Particles:Emit(celeste.BadelineOldsite.P_Vanish, 24, stranger.Center, vector2(10,10))
  stranger:removeSelf()
  wait(1)

  player.ForceCameraUpdate = true
  wait(0.5)
  setFlag("monstro5")
  enableMovement()

  end

end

function onEnd(wasSkipped)
  if wasSkipped then
    if waitingCoroutine then
      waitingCoroutine:Cancel()
      cutsceneEntity:Remove(waitingCoroutine)
    end
    if stranger then
      stranger:removeSelf()
    end
    player.ForceCameraUpdate = true
    setFlag("monstro5")
    enableMovement()
  end
end