local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local Ease = require("#Monocle.Ease")

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function camera()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(3592, -3936), 2, Ease.ExpoOut, 0))
end


function onBegin()

  if not getFlag("chegadefugir") then

  disableMovement()
  player.ForceCameraUpdate = false
  waitingCoroutine = makeCoroutine(camera)
  cutsceneEntity:Add(waitingCoroutine)
  setInventory("Prologue")
  player.Dashes = 0
  wait(1)

  coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CelesteBrasil_wanderbirthdaymap_blackspace"))
  wait(0.25)

  player.ForceCameraUpdate = true
  setCameraOffset(2.5, -2)
  wait(0.5)

  setFlag("chegadefugir")
  enableMovement()

  end

end

function onEnd(wasSkipped)
  if wasSkipped then
    if waitingCoroutine then
      waitingCoroutine:Cancel()
      cutsceneEntity:Remove(waitingCoroutine)
    end
    setInventory("Prologue")
    player.Dashes = 0
    player.ForceCameraUpdate = true
    setCameraOffset (2.5, -2)
    setFlag("chegadefugir")
    enableMovement()
  end
end