local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local Ease = require("#Monocle.Ease")

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function camera()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(-9260, -6373), 4, Ease.ExpoOut, 0))
end


function onBegin()

  if not getFlag("monstro3") then

  mostros_oshiro = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("mostros_oshiro")

  disableMovement()
  player.ForceCameraUpdate = false
  waitingCoroutine = makeCoroutine(camera)
  cutsceneEntity:Add(waitingCoroutine)
  wait(1)

  coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CelesteBrasil_wanderbirthdaymap_monstrooshiro"))
  wait(0.5)

  playSound("event:/char/badeline/disappear", mostros_oshiro.Position)
  getRoom().Displacement:AddBurst(mostros_oshiro.Position + vector2(0, 0), 0.5, 24, 96, 1.4, nil, nil)
  getLevel().Particles:Emit(celeste.BadelineOldsite.P_Vanish, 48, mostros_oshiro.Center, vector2(20,20))
  mostros_oshiro:removeSelf()
  wait(1)

  player.ForceCameraUpdate = true
  wait(0.5)
  setFlag("monstro2")
  enableMovement()

  end

end

function onEnd(wasSkipped)
  if wasSkipped then
    if waitingCoroutine then
      waitingCoroutine:Cancel()
      cutsceneEntity:Remove(waitingCoroutine)
    end
    if mostros_oshiro then
      mostros_oshiro:removeSelf()
    end
    player.ForceCameraUpdate = true
    setFlag("monstro3")
    enableMovement()
  end
end