local function doFadeWipe(state)
  fadeWipe = celeste.FadeWipe(engine.Scene, state, nil)
  engine.Scene:Add(fadeWipe)
  fadeWipe.duration = 8
  fadeWipe.EndTimer = 3
end

local Ease = require("#Monocle.Ease")


function onBegin()

  if getFlag("introblackspacestart") then

    intro = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("introblackspace")
    intro.Position = vector2(4168, 94)
    intro:PlayAnimation("blackscreen")
    disablePause()
    disableMovement()
    player.DummyAutoAnimate = false
    player.ForceCameraUpdate = false
    wait(2)

    playSound("event:/game/wanderBDay2/omori_introblackspace1", player.Position)
    intro:PlayAnimation("intro1")
    wait(5)

    playSound("event:/game/wanderBDay2/omori_introblackspace2", player.Position)
    intro:PlayAnimation("intro2")
    wait(5)

    intro:PlayAnimation("introend")
    wait(3)

    setFlag("musicblackspace")
    wait(2)

    doFadeWipe(true)
    coroutine.yield(celeste.cutsceneEntity.CameraTo(player.Position + vector2(-160, -484), 0, Ease.Linear, 0))
    intro:RemoveSelf()
    wait(3)


    player.Sprite:Play("asleep", false, false)
    coroutine.yield(celeste.cutsceneEntity.CameraTo(player.Position + vector2(-160, -164), 10, Ease.Linear, 2))
    wait(1)

    player.Sprite:Play("wakeup", true, false)
    wait(2.5)

    player.ForceCameraUpdate = true
    player.DummyAutoAnimate = true
    setFlag("introblackspacestart", false)
    enableMovement()
    enablePause()
    setFlag("desparar3")

  end

end