local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local Vector2 = require("#microsoft.xna.framework.vector2")

local Ease = require("#Monocle.Ease")

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function camera1()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9341, 7268), 2, Ease.CubeOut, 0))
end

local function camera2()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9341, 7268), 4, Ease.Linear, 0))
end

local function gototrono()
  walk(1927)
end


function onBegin()

  if getFlag("enddoor3") then

    disablePause()
    disableMovement()
    player.ForceCameraUpdate = false

    badelinepega = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("badelinepega")
    something = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("something")
    something_atk = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("something_atk")
    something_laser = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("something_laser")

    badelinepega.Position = vector2(9632, 7400)
    waitingCoroutine = makeCoroutine(camera1)
    cutsceneEntity:Add(waitingCoroutine)
    walkTo(9406)
    wait(2)

    say("CBR_BlackSpace_door3_redspace_badeline1")
    something.Position = player.Position + vector2(-100, 0)
    something:PlayAnimation("idle_stranger")
    wait(0.5)

    coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9266, 7268), 4, Ease.Linear, 0))
    wait(0.5)

    waitingCoroutine = makeCoroutine(camera2)
    cutsceneEntity:Add(waitingCoroutine)

    for i = 0, 4, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, 0), monocle.Ease.Linear(0.75))
      something:PlayAnimation("walk")
      wait()
    end

    something:PlayAnimation("idle_stranger")

    wait(1)

    playSound("event:/game/03_resort/clutterswitch_finish")
    something:PlayAnimation("transform")
    wait(2)

    something:PlayAnimation("move_something")
    wait(0.5)

    something:SetHorizontalScale(-1)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_redspace_something1"))
    wait(0.5)

    something:SetHorizontalScale(1)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_redspace_something2"))
    wait(0.5)

    for i = 0, 2.3, monocle.Engine.DeltaTime do
      badelinepega.Position = Vector2.Lerp(badelinepega.Position, badelinepega.Position + vector2(-0.5, -1), monocle.Ease.Linear(0.25))
      wait()
    end

    wait(0.5)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_redspace_something3"))

    something_atk.Position = something.Position + vector2(16, -34)

    something_laser.Position = something.Position + vector2(16, -34)

    something_atk:PlayAnimation("atkbegin")
    something_laser:PlayAnimation("atkcharge")
    playSound("event:/char/badeline/boss_laser_charge")

    wait(1.5)
    say("CBR_BlackSpace_door3_redspace_badeline2")

    something_atk:PlayAnimation("atklock")
    something_laser:PlayAnimation("atklock")

    wait(0.75)

    playSound("event:/char/badeline/boss_laser_fire")
    setFlag("stopmusic3")
    something_laser:PlayAnimation("atkshoot")
    something_atk:PlayAnimation("atkend")
    badelinepega:PlayAnimation("badelinedead")
    wait(2)

    badelinepega:PlayAnimation("fadehand")
    wait(2)

    something:SetHorizontalScale(-1)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_redspace_something4"))
    wait(0.5)

    waitingCoroutine = makeCoroutine(gototrono)
    cutsceneEntity:Add(waitingCoroutine)

    wait(1.4)
    something:SetHorizontalScale(1)

    wait(0.2)
    player.ForceCameraUpdate = true



    for i = 0, 7.2, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, 0), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 6.26, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, -0.5), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 1.21, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, 0), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 2.50, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, -0.5), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 2.30, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, 0), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 1.24, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, -0.5), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 2.25, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, 0), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 1.26, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, -0.5), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 2.24, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, 0), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 1.22, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, -0.5), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end


    for i = 0, 0.51, monocle.Engine.DeltaTime do
      something.Position = Vector2.Lerp(something.Position, something.Position + vector2(1, 0), monocle.Ease.Linear(1.065))
      something:PlayAnimation("move_something")
      wait()
    end

    wait(1)
    jump()
    wait(2.5)

    player.DummyAutoAnimate = false
    player.Sprite:Play("sleep", false, false)
    wait(0.5)

    coroutine.yield(getLevel():ZoomTo(vector2(160, 80), 4, 10))
    player.Sprite:Play("evilsleep", false, false)
    wait(3)

    completeArea(false, false, true)

  end

end