local function doFadeWipe(state)
  fadeWipe = celeste.FadeWipe(engine.Scene, state, nil)
  engine.Scene:Add(fadeWipe)
  fadeWipe.duration = 2
  fadeWipe.EndTimer = 1
end

local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local Ease = require("#Monocle.Ease")

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function camera1()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9698, 6176), 2, Ease.CubeOut, 0))
end


function onBegin()

  if getFlag("verbadeline2") then

    disablePause()
    disableMovement()
    player.ForceCameraUpdate = false
    waitingCoroutine = makeCoroutine(camera1)
    cutsceneEntity:Add(waitingCoroutine)
    walkTo(9878)
    wait(0.5)

    say("CBR_BlackSpace_door3_igreja_badeline1")
    wait(0.5)

    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME", "CBR_BlackSpace_door3_igreja_silence"))
    wait(0.5)

    say("CBR_BlackSpace_door3_igreja_badeline2")
    wait(0.1)

    badelinepresa = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("badelinepresa")
    badelinepresa:PlayAnimation("absorve1")
    playSound("event:/game/wanderBDay2/omori_absorb_badeline_01")
    wait(0.1)

    say("CBR_BlackSpace_door3_igreja_badeline3")
    badelinepresa:PlayAnimation("absorve2")
    playSound("event:/game/wanderBDay2/omori_absorb_badeline_02")
    wait(0.1)

    say("CBR_BlackSpace_door3_igreja_badeline4")
    badelinepresa:PlayAnimation("absorve3")
    playSound("event:/game/wanderBDay2/omori_absorb_badeline_03")
    wait(0.1)

    say("CBR_BlackSpace_door3_igreja_badeline5")
    badelinepresa:PlayAnimation("absorvefim")
    playSound("event:/char/badeline/temple_move_chats")
    wait(2)

    walkTo(9908)
    playerfade = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("playerfade")
    playerfade.Depth = -1
    playerfade:PlayAnimation("fadein")
    wait(2)

    doFadeWipe(false)
    wait(1.3)
    player.ForceCameraUpdate = true
    setFlag("verbadeline2", false)
    setFlag("enterredspace")

  end

end