local function doFadeWipe(state)
  local Color = require("#Microsoft.Xna.Framework.Color")
  local screenWipe = require("#Celeste.ScreenWipe")
    fadeWipe = celeste.FadeWipe(engine.Scene, state, nil)
    engine.Scene:Add(fadeWipe)
    fadeWipe.duration = 8
    fadeWipe.EndTimer = 3
    screenWipe.WipeColor = Color.White
end


local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local Ease = require("#Monocle.Ease")

local Vector2 = require("#microsoft.xna.framework.vector2")

local Audio = require("#celeste.Audio")

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function camera1()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9698, 5246), 4, Ease.ExpoOut, 0))
end

local function camera2()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9528, 5355), 5, Ease.Linear, 0))
end

local function camera3()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9698, 5276), 5, Ease.Linear, 0))
end

local function burstline()
  playSound("event:/game/general/crystalheart_pulse", badelinelivre.Position)
  getRoom().Displacement:AddBurst(badelinelivre.Position + vector2(-4, 0), 3, 24, 500, 1.5, nil, nil)
end

local function tremedeira()
  terremotosfx = Audio.Play("event:/game/06_reflection/badeline_pull_rumble_loop", badelinelivre.Position)
  player.ForceCameraUpdate = false
  local contagem = 0
    while contagem < 1 do
      coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(9698, 5270), 0, monocle.Ease.Linear, 0))
      wait()
      coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(9698, 5269), 0, monocle.Ease.Linear, 0))
      wait()
      contagem = contagem + 0
    end
end


function onBegin()

  if getFlag("verbadeline") then

    disablePause()
    disableMovement()
    player.ForceCameraUpdate = false
    waitingCoroutine = makeCoroutine(camera1)
    cutsceneEntity:Add(waitingCoroutine)
    waitUntilOnGround()
    walkTo(9797)
    wait(1)

    stranger = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("stranger")
    stranger.Position = vector2(9587, 5515)
    wait(0.1)

    waitingCoroutine = makeCoroutine(camera2)
    cutsceneEntity:Add(waitingCoroutine)
    wait(1.5)

    player.Facing = getEnum("Celeste.Facings", "Left")
    wait(3)

    for i = 0, 1.5, monocle.Engine.DeltaTime do
      stranger.Position = Vector2.Lerp(stranger.Position, stranger.Position + vector2(1, -1), Ease.Linear(0.75))
      stranger:PlayAnimation("walk")
      wait()
    end

    for i = 0, 1, monocle.Engine.DeltaTime do
      stranger.Position = Vector2.Lerp(stranger.Position, stranger.Position + vector2(1, 0), Ease.Linear(0.75))
      stranger:PlayAnimation("walk")
      wait()
    end

    stranger:PlayAnimation("idle")
    wait(1)

    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_igreja_finalbom_stranger1"))
    wait(0.1)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_igreja_finalbom_stranger2"))
    wait(0.1)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_igreja_finalbom_stranger3"))
    wait(1)

    waitingCoroutine = makeCoroutine(camera3)
    cutsceneEntity:Add(waitingCoroutine)

    for i = 0, 2.55, monocle.Engine.DeltaTime do
      stranger.Position = Vector2.Lerp(stranger.Position, stranger.Position + vector2(1, 0), Ease.Linear(0.75))
      stranger:PlayAnimation("walk")
      if i > 2.2 then
        player.Facing = getEnum("Celeste.Facings", "Right")
      end
      wait()
    end

    badelinelivre = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("badelinelivre")
    waitingCoroutine:Cancel()
    waitingCoroutine = makeCoroutine(burstline)
    cutsceneEntity:Add(waitingCoroutine)

    for i = 0, 1, monocle.Engine.DeltaTime do
      stranger.Position = Vector2.Lerp(stranger.Position, stranger.Position + vector2(1, -1), Ease.Linear(0.75))
      stranger:PlayAnimation("walk")
      wait()
    end

    stranger:PlayAnimation("idle")

    coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9698, 5270), 1, Ease.CubeOut, 0))
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_igreja_finalbom_stranger4"))
    wait(0.5)

    pontos = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("pontos")
    pontos.Position = badelinelivre.Position + vector2(-5, -16)
    receba = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("receba")
    receba.Depth = -1

    receba.Position = badelinelivre.Position + vector2(-35, -100)
    receba:PlayAnimation("flor1")
    for i = 0, 2, monocle.Engine.DeltaTime do
      receba.Position = Vector2.Lerp(receba.Position, receba.Position + vector2(0.4, 1.3), monocle.Ease.SineOut(i))
      if i > 1 then
        receba:PlayAnimation("fadeflor1")
      end
      wait()
    end
    playSound("event:/game/wanderBDay2/flor1", badelinelivre.Position)
    pontos:PlayAnimation("1000")

    receba.Position = badelinelivre.Position + vector2(25, -100)
    receba:PlayAnimation("flor2")
    for i = 0, 2, monocle.Engine.DeltaTime do
      receba.Position = Vector2.Lerp(receba.Position, receba.Position + vector2(-0.4, 1.3), monocle.Ease.SineOut(i))
      if i > 1 then
        receba:PlayAnimation("fadeflor2")
      end
      wait()
    end
    playSound("event:/game/wanderBDay2/flor2", badelinelivre.Position)
    pontos:PlayAnimation("2000")

    receba.Position = badelinelivre.Position + vector2(-35, -100)
    receba:PlayAnimation("flor3")
    for i = 0, 2, monocle.Engine.DeltaTime do
      receba.Position = Vector2.Lerp(receba.Position, receba.Position + vector2(0.4, 1.3), monocle.Ease.SineOut(i))
      if i > 1 then
        receba:PlayAnimation("fadeflor3")
      end
      wait()
    end
    playSound("event:/game/wanderBDay2/flor3", badelinelivre.Position)
    pontos:PlayAnimation("3000")

    receba.Position = badelinelivre.Position + vector2(25, -100)
    receba:PlayAnimation("flor4")
    for i = 0, 2, monocle.Engine.DeltaTime do
      receba.Position = Vector2.Lerp(receba.Position, receba.Position + vector2(-0.4, 1.3), monocle.Ease.SineOut(i))
      if i > 1 then
        receba:PlayAnimation("fadeflor4")
      end
      wait()
    end
    playSound("event:/game/wanderBDay2/flor4", badelinelivre.Position)
    pontos:PlayAnimation("4000")

    receba.Position = badelinelivre.Position + vector2(-35, -100)
    receba:PlayAnimation("flor5")
    for i = 0, 2, monocle.Engine.DeltaTime do
      receba.Position = Vector2.Lerp(receba.Position, receba.Position + vector2(0.4, 1.3), monocle.Ease.SineOut(i))
      if i > 1 then
        receba:PlayAnimation("fadeflor5")
      end
      wait()
    end
    playSound("event:/game/wanderBDay2/flor5", badelinelivre.Position)
    pontos:PlayAnimation("5000")

    receba.Position = badelinelivre.Position + vector2(25, -100)
    receba:PlayAnimation("flor6")
    for i = 0, 2, monocle.Engine.DeltaTime do
      receba.Position = Vector2.Lerp(receba.Position, receba.Position + vector2(-0.4, 1.3), monocle.Ease.SineOut(i))
      if i > 1 then
        receba:PlayAnimation("fadeflor6")
      end
      wait()
    end
    playSound("event:/game/wanderBDay2/flor6", badelinelivre.Position)
    pontos:PlayAnimation("6000")

    receba.Position = badelinelivre.Position + vector2(-5, -100)
    receba:PlayAnimation("flor7")
    for i = 0, 2, monocle.Engine.DeltaTime do
      receba.Position = Vector2.Lerp(receba.Position, receba.Position + vector2(0, 1.3), monocle.Ease.SineOut(i))
      if i > 1 then
        receba:PlayAnimation("fadeflor7")
      end
      wait()
    end
    playSound("event:/game/wanderBDay2/flor7", badelinelivre.Position)
    pontos:PlayAnimation("1up")

    receba:PlayAnimation("invisible")
    wait(2)

    say("CBR_BlackSpace_door3_igreja_finalbom_badeline1")
    wait(0.25)

    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_igreja_finalbom_stranger5"))

    badelinelivre:PlayAnimation("powerup1")
    waitingCoroutine = makeCoroutine(tremedeira)
    cutsceneEntity:Add(waitingCoroutine)
    wait(0.25)

    player.DummyAutoAnimate = false
    player.Sprite:Play("shaking", false, false)

    say("CBR_BlackSpace_door3_igreja_finalbom_badeline2")
    wait(0.25)

    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_igreja_finalbom_stranger6"))
    wait(0.25)

    choquesfx = Audio.Play("event:/new_content/env/10_electricity", badelinelivre.Position)
    badelinelivre:PlayAnimation("powerup2")
    wait(0.25)

    say("CBR_BlackSpace_door3_igreja_finalbom_badeline3")

    badelinelivre:PlayAnimation("powerup3")
    wait(1)

    prisao = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("prisao")
    prisao:PlayAnimation("iluminar")
    wait(1)

    doFadeWipe(false)
    wait(5)

    player.DummyAutoAnimate = true
    waitingCoroutine:Cancel()
    Audio.Stop(terremotosfx, true)
    Audio.Stop(choquesfx, true)
    setFlag("verbadeline", false)
    setFlag("msgroom")

  end

end