local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local Ease = require("#Monocle.Ease")

local Vector2 = require("#microsoft.xna.framework.vector2")

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function camera1()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9698, 6166), 4, Ease.ExpoOut, 0))
end

local function camera2()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9528, 6275), 5, Ease.Linear, 0))
end

local function camera3()
  coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9698, 6196), 5, Ease.Linear, 0))
end


function onBegin()

  if getFlag("verbadeline") then

    disablePause()
    disableMovement()
    player.ForceCameraUpdate = false
    waitingCoroutine = makeCoroutine(camera1)
    cutsceneEntity:Add(waitingCoroutine)
    waitUntilOnGround()
    walkTo(9797)
    wait(1)

    stranger = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("stranger")
    stranger.Position = vector2(9587, 6435)
    wait(0.1)

    waitingCoroutine = makeCoroutine(camera2)
    cutsceneEntity:Add(waitingCoroutine)
    wait(1.5)

    player.Facing = getEnum("Celeste.Facings", "Left")
    wait(3)

    for i = 0, 1.5, monocle.Engine.DeltaTime do
      stranger.Position = Vector2.Lerp(stranger.Position, stranger.Position + vector2(1, -1), Ease.Linear(0.75))
      stranger:PlayAnimation("walk")
      wait()
    end

    for i = 0, 1, monocle.Engine.DeltaTime do
      stranger.Position = Vector2.Lerp(stranger.Position, stranger.Position + vector2(1, 0), Ease.Linear(0.75))
      stranger:PlayAnimation("walk")
      wait()
    end

    stranger:PlayAnimation("idle")
    wait(1)

    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_igreja_stranger1"))
    wait(0.1)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_igreja_stranger2"))
    wait(0.1)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME2", "CBR_BlackSpace_door3_igreja_stranger3"))
    wait(1)

    waitingCoroutine = makeCoroutine(camera3)
    cutsceneEntity:Add(waitingCoroutine)

    for i = 0, 2.55, monocle.Engine.DeltaTime do
      stranger.Position = Vector2.Lerp(stranger.Position, stranger.Position + vector2(1, 0), Ease.Linear(0.75))
      stranger:PlayAnimation("walk")
      if i > 2.2 then
        player.Facing = getEnum("Celeste.Facings", "Right")
      end
      wait()
    end

    for i = 0, 2, monocle.Engine.DeltaTime do
      stranger.Position = Vector2.Lerp(stranger.Position, stranger.Position + vector2(1, -1), Ease.Linear(0.75))
      stranger:PlayAnimation("walk")
      wait()
    end

    stranger:PlayAnimation("sumir")
    wait(3)

    coroutine.yield(celeste.cutsceneEntity.CameraTo(vector2(9634, 6262), 4, Ease.Linear, 0))
    player.ForceCameraUpdate = true
    wait(1)

    setFlag("verbadeline", false)
    setFlag("verbadeline2")
    enableMovement()
    enablePause()

  end

end