local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local Vector2 = require("#microsoft.xna.framework.vector2")

local Audio = require("#celeste.Audio")


function onBegin()

  if getFlag("finishtreehouse") and not getFlag("enterelevator") then

    player.ForceCameraUpdate = true
    disablePause()
    disableMovement()
    waitUntilOnGround()
    wait(0.5)

    elevator = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("elevator")
    elevator:PlayAnimation("idle")
    elevator.Position = vector2(4840, 5970)
    elevator.Depth = 1001
    sfxelevatoractive = Audio.Play("event:/env/amb/wanderbirthdaymap/blackspace_elevator", elevator.Position)

    p = 0
    while p < 1 do
      elevator.Position = Vector2.Lerp(elevator.Position, elevator.Position + vector2(0, 1), monocle.Ease.Linear(p))
      p = p + (engine.TimeRate / 300)
      wait()

      if p > 0.5 then
        player.Facing = getEnum("Celeste.Facings", "Left")
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("basil"):SetHorizontalScale(-1)
      end
    end

    wait(0.5)
    Audio.Stop(sfxelevatoractive, false)
    sfxelevatording = Audio.Play("event:/game/WanderBDay/omori_elevatording", elevator.Position)
    wait(1)

    elevator:PlayAnimation("open")
    wait(1)

    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME", "CBR_BlackSpace_door2_elevator_basil1"))

    setFlag("enterelevator")
    enableMovement()
    enablePause()

  end

end