local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local function doFadeWipe(state)
  fadeWipe = celeste.FadeWipe(engine.Scene, state, nil)
  engine.Scene:Add(fadeWipe)
  fadeWipe.duration = 2
  fadeWipe.EndTimer = 2
end


function onTalk()

  if getFlag("aparicao") then

    disablePause()
    disableMovement()
    player.ForceCameraUpdate = true

    coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("OMORI_GAME", "CBR_BlackSpace_door1_room3_choice1", "CBR_BlackSpace_door1_room3_choice2"))
    local multipla = luaCutscenesUtils.GetChoice()

    if multipla == 1 then

      wait(1)
      doFadeWipe(false)
      wait(2)

      doorCS = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("doorCS")
      doorCS:PlayAnimation("blackscreen")
      wait(2)

      doorCS:PlayAnimation("open")
      playSound("event:/game/WanderBDay/omori_dooropen", player.Position)
      wait(3.5)

      doorCS:PlayAnimation("close")
      wait(0.5)
      playSound("event:/game/03_resort/door_wood_close", player.Position)
      wait(2.5)

      doFadeWipe(true)
      doorCS:removeSelf()
      walkTo(3242)
      wait()

      setFlag("aparicao", false)
      setFlag("corredor")
      enableMovement()
      enablePause()

    else

      wait(0.2)
      walkTo(3242)
      wait(0.2)
      setFlag("aparicao", false)
      setFlag("corredor")
      enableMovement()
      enablePause()

    end

  end

end