local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end


local function falalerda1()
  wait(0.65)
  for i = 0, 13, 1 do
    playSound("event:/game/WanderBDay/omori_dialog_regular", player.Position)
    wait(0.25)
  end
end

local function falalerda2()
  wait(0.4)
    for i = 0, 14, 1 do
      playSound("event:/game/WanderBDay/omori_dialog_regular", player.Position)
      wait(0.25)
    end
  end


function onBegin()

  if not getFlag("aparicao") then

    disablePause()
    disableMovement()
    player.ForceCameraUpdate = true
    waitUntilOnGround()
    wait(0.5)

    setFlag("door_abrirfechar", true)
    playSound("event:/game/03_resort/door_wood_open")
    wait(1)

    aparicao = celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("aparicao")
    aparicao:PlayAnimation("aparecer")
    wait(2.5)

    waitingCoroutine = makeCoroutine(falalerda1)
    cutsceneEntity:Add(waitingCoroutine)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME", "CBR_BlackSpace_door1_room3_pipipi"))

    waitingCoroutine = makeCoroutine(falalerda2)
    cutsceneEntity:Add(waitingCoroutine)
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME", "CBR_BlackSpace_door1_room3_pipipi"))

    aparicao:PlayAnimation("sumir")
    wait(2.5)

    setFlag("door_abrirfechar", false)
    wait(0.3)
    playSound("event:/game/03_resort/door_wood_close")
    wait(0.5)

    setFlag("aparicao")
    enableMovement()
    enablePause()

  end

end