#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float4 l2(float4 i, float4 j, float t)
{
    if(t <= 0.5){
        return lerp(i, j, t*2);
    } else {
        return lerp(i, j, (1-t)*2);
    }
}

float s2(float x) {
return -(cos(3.14159265 * x) - 1) / 2;

}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 biguv = (uv * Dimensions) + CamPos;

    float Time2 = Time / 8;
    float factor = 0;
    float4 color = SAMPLE_TEXTURE(text, uv);

    int range = 1;

    const int bayer_n = 4;
    float bayer_matrix_4x4[][bayer_n] = {
    {    -0.5,       0,  -0.375,   0.125 },
    {    0.25,   -0.25,   0.375, - 0.125 },
    { -0.3125,  0.1875, -0.4375,  0.0625 },
    {  0.4375, -0.0625,  0.3125, -0.1875 },
    };

    float dither_strength = 0.12;
    float luminance_offset = 0.00;

    float bayer_value = bayer_matrix_4x4[floor(biguv.y) % bayer_n][floor(biguv.x) % bayer_n] * dither_strength;

    color = color + (range * (bayer_value / 2));

    //float lum = sqrt( 0.299*color.r*color.r + 0.587*color.g*color.g + 0.114*color.b*color.b ) + luminance_offset;
    //lum = round(lum * 32) / 32;
    color.rgb = floor(color.rgb * 16) / 16;
    //color = float4(lum, lum, lum, 1);

    return color;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}