local utils = require("utils")

local knowledgeTriangle = {}

knowledgeTriangle.name = "RainKit/KnowledgeTriangle"
knowledgeTriangle.depth = 2000
knowledgeTriangle.placements = {
    {
        name = "normal",
        data = {
            golden = false
        }
    },
    {
        name = "golden",
        data = {
            golden = true
        }
    }
}

function knowledgeTriangle.texture(room, entity)
    local golden = entity.golden

    if golden then
        return "objects/RainKit/knowledge/goldenTriangle1"
    else
        return "objects/RainKit/knowledge/triangle1"
    end
end

function knowledgeTriangle.selection(room, entity)
    return utils.rectangle(entity.x - 9, entity.y - 9, 19, 19)
end

return knowledgeTriangle