local mods = require("mods")
local utils = require("utils")
local drawableSprite = require("structs.drawable_sprite")
local drawableRectangle = require("structs.drawable_rectangle")
local drawableLine = require("structs.drawable_line")

local water_rain_attachment = {}

water_rain_attachment.name = "RainTools/WaterRainAttachment"
water_rain_attachment.depth = 0
water_rain_attachment.nodeLimits = {4, 4}
water_rain_attachment.nodeVisibility = "always"
water_rain_attachment.texture = "RainTools/water_rain_attachment"
water_rain_attachment.placements = {
  name = "water_rain_attachment",
  data = {
    fillTime = 5,
    drainTime = 5,
  }
}

function water_rain_attachment.nodeSprite(room, entity, node, index)
  if index == 1 then
    return drawableLine.fromPoints({entity.x, entity.y, node.x, node.y}, {1, 1, 1, 0.4}):getDrawableSprite()
  else
    return drawableLine.fromPoints({entity.nodes[index - 1].x, entity.nodes[index - 1].y, node.x, node.y}, {1, 1, 1, 0.4}):getDrawableSprite()
  end
end

function water_rain_attachment.nodeRectangle(room, entity, node)
  return utils.rectangle(node.x - 4, node.y - 4, 8, 8)
end

return water_rain_attachment
