local mods = require("mods")
local utils = require("utils")
local drawableSprite = require("structs.drawable_sprite")
local drawableLine = require("structs.drawable_line")

local rain_controller = {}

rain_controller.name = "RainTools/RainController"
rain_controller.depth = 0
rain_controller.nodeLimits = {1, 1}
rain_controller.nodeVisibility = "always"
rain_controller.texture = "RainTools/rain_controller"
rain_controller.placements = {
  name = "controller",
  data = {
    cycleTag = "",
    advanceChances = "",
    advanceTime = 50,
    lightningChance = 0.5,
    lightningInterval = 50,
    onlyIn = "",
    floodSfxOnlyIn = "",
    chanceDecreaseAmount = 0.1,
    rainWaterFillTime = 120,
    rainWaterDrainTime = 120,
    playerLightningTargetChance = 0.5,
  }
}

function rain_controller.nodeSprite(room, entity, node, index)
  return drawableLine.fromPoints({entity.x, entity.y, node.x, node.y}, {1, 1, 1, 0.4}):getDrawableSprite()
end

function rain_controller.nodeRectangle(room, entity, node)
  return utils.rectangle(node.x - 4, node.y - 4, 8, 8)
end

return rain_controller
